/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shade.client.utils.jdbc;

import io.openlineage.spark.shade.client.utils.DatasetIdentifier;
import io.openlineage.spark.shade.client.utils.jdbc.CrateJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.Db2JdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.DerbyJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.GenericJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.JdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.JdbcLocation;
import io.openlineage.spark.shade.client.utils.jdbc.JdbcUrlSanitizer;
import io.openlineage.spark.shade.client.utils.jdbc.MySqlJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.OceanBaseJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.OracleJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.PostgresJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.SqlServerJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.TeradataJdbcExtractor;
import io.openlineage.spark.shade.client.utils.jdbc.TrinoJdbcExtractor;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatasetUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcDatasetUtils.class);
    private static final JdbcExtractor[] extractors = new JdbcExtractor[]{new PostgresJdbcExtractor(), new OracleJdbcExtractor(), new MySqlJdbcExtractor(), new SqlServerJdbcExtractor(), new TeradataJdbcExtractor(), new DerbyJdbcExtractor(), new CrateJdbcExtractor(), new Db2JdbcExtractor(), new TrinoJdbcExtractor(), new OceanBaseJdbcExtractor(), new GenericJdbcExtractor()};

    private static JdbcExtractor getExtractor(String jdbcUri) throws URISyntaxException {
        for (JdbcExtractor extractor : extractors) {
            if (!extractor.isDefinedAt(jdbcUri)) continue;
            return extractor;
        }
        throw new URISyntaxException(jdbcUri, "Unsupported JDBC URL");
    }

    public static DatasetIdentifier getDatasetIdentifier(String jdbcUrl, String name, Properties properties) {
        List<String> parts = Arrays.stream(name.split("\\.")).collect(Collectors.toList());
        return JdbcDatasetUtils.getDatasetIdentifier(jdbcUrl, parts, properties);
    }

    public static DatasetIdentifier getDatasetIdentifier(String jdbcUrl, List<String> parts, Properties properties) {
        String uri = jdbcUrl.replaceAll("^(?i)jdbc:", "");
        try {
            JdbcExtractor extractor = JdbcDatasetUtils.getExtractor(uri);
            JdbcLocation location = extractor.extract(uri, properties);
            return new DatasetIdentifier(location.toName(parts), location.toNamespace());
        }
        catch (URISyntaxException e) {
            log.debug("Failed to parse jdbc url", (Throwable)e);
            return new DatasetIdentifier(String.join((CharSequence)".", parts), JdbcUrlSanitizer.dropSensitiveData(uri));
        }
    }
}

