/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant;

import io.openliberty.tools.ant.AbstractTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class SpringBootUtilTask
extends AbstractTask {
    private String sourceAppPath;
    private String targetLibCachePath;
    private String targetThinAppPath;
    private String parentLibCachePath;
    private String command_name = "springBootUtility";
    private String cmd;

    @Override
    protected void initTask() {
        super.initTask();
        if (isWindows) {
            this.cmd = this.installDir + "\\bin\\" + this.command_name + ".bat";
            this.processBuilder.environment().put("EXIT_ALL", "1");
        } else {
            this.cmd = this.installDir + "/bin/" + this.command_name;
        }
        Properties sysp = System.getProperties();
        String javaHome = sysp.getProperty("java.home");
        this.processBuilder.directory(this.installDir);
        this.processBuilder.environment().put("JAVA_HOME", javaHome);
        this.processBuilder.redirectErrorStream(true);
    }

    public void execute() {
        this.initTask();
        File f = new File(this.cmd);
        if (f.exists()) {
            try {
                this.processCommand(this.buildCommand());
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            throw new BuildException("The " + this.command_name + " command could not be invoked because it does not exist. Add the Spring Boot feature to the Liberty server configuration and try again.");
        }
    }

    private List<String> buildCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.cmd);
        command.add("thin");
        command.add("--sourceAppPath=" + this.getSourceAppPath());
        command.add("--targetLibCachePath=" + this.getTargetLibCachePath());
        command.add("--targetThinAppPath=" + this.getTargetThinAppPath());
        if (this.getParentLibCachePath() != null) {
            command.add("--parentLibCachePath=" + this.getParentLibCachePath());
        }
        return command;
    }

    private void processCommand(List<String> command) throws Exception {
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), 0);
    }

    public String getSourceAppPath() {
        return this.sourceAppPath;
    }

    public void setSourceAppPath(String sourceAppPath) {
        this.sourceAppPath = sourceAppPath;
    }

    public String getTargetLibCachePath() {
        return this.targetLibCachePath;
    }

    public void setTargetLibCachePath(String targetLibCachePath) {
        this.targetLibCachePath = targetLibCachePath;
    }

    public String getParentLibCachePath() {
        return this.parentLibCachePath;
    }

    public void setParentLibCachePath(String parentLibCachePath) {
        this.parentLibCachePath = parentLibCachePath;
    }

    public String getTargetThinAppPath() {
        return this.targetThinAppPath;
    }

    public void setTargetThinAppPath(String targetThinAppPath) {
        this.targetThinAppPath = targetThinAppPath;
    }
}

