/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.testing.common;

import com.google.common.math.LongMath;
import io.opencensus.common.Clock;
import io.opencensus.common.Duration;
import io.opencensus.common.Timestamp;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TestClock
extends Clock {
    private static final int NUM_NANOS_PER_SECOND = 1000000000;
    @GuardedBy(value="this")
    private Timestamp currentTime = TestClock.validateNanos(Timestamp.create((long)1493419949L, (int)223123456));

    private TestClock() {
    }

    public static TestClock create() {
        return new TestClock();
    }

    public static TestClock create(Timestamp time) {
        TestClock clock = new TestClock();
        clock.setTime(time);
        return clock;
    }

    public synchronized void setTime(Timestamp time) {
        this.currentTime = TestClock.validateNanos(time);
    }

    public synchronized void advanceTime(Duration duration) {
        this.currentTime = TestClock.validateNanos(this.currentTime.addDuration(duration));
    }

    public synchronized Timestamp now() {
        return this.currentTime;
    }

    public synchronized long nowNanos() {
        return TestClock.getNanos(this.currentTime);
    }

    private static Timestamp validateNanos(Timestamp time) {
        TestClock.getNanos(time);
        return time;
    }

    private static long getNanos(Timestamp time) {
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)time.getSeconds(), (long)1000000000L), (long)time.getNanos());
    }
}

