/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentIntrusiveList<T extends Element<T>> {
    private int size = 0;
    private T head = null;

    public synchronized void addElement(T element) {
        Preconditions.checkArgument((element.getNext() == null && element.getPrev() == null && element != this.head ? 1 : 0) != 0, (Object)"Element already in a list.");
        ++this.size;
        if (this.head == null) {
            this.head = element;
        } else {
            element.setNext(this.head);
            this.head.setPrev(element);
            this.head = element;
        }
    }

    public synchronized void removeElement(T element) {
        Preconditions.checkArgument((element.getNext() != null || element.getPrev() != null || element == this.head ? 1 : 0) != 0, (Object)"Element not in the list.");
        --this.size;
        if (element.getPrev() == null) {
            this.head = element.getNext();
            if (this.head != null) {
                this.head.setPrev(null);
                element.setNext(null);
            }
        } else if (element.getNext() == null) {
            element.getPrev().setNext(null);
            element.setPrev(null);
        } else {
            element.getPrev().setNext(element.getNext());
            element.getNext().setPrev(element.getPrev());
            element.setNext(null);
            element.setPrev(null);
        }
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized Collection<T> getAll() {
        ArrayList<T> all = new ArrayList<T>(this.size);
        for (T e = this.head; e != null; e = e.getNext()) {
            all.add(e);
        }
        return all;
    }

    public static interface Element<T extends Element<T>> {
        public T getNext();

        public void setNext(T var1);

        public T getPrev();

        public void setPrev(T var1);
    }
}

