/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.implcore.stats.MutableAggregation;
import io.opencensus.implcore.tags.TagMapImpl;
import io.opencensus.implcore.tags.TagValueWithMetadata;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.Measure;
import io.opencensus.stats.Measurement;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class RecordUtils {
    @Nullable
    @VisibleForTesting
    static final TagValue UNKNOWN_TAG_VALUE = null;
    @VisibleForTesting
    static final TagKey RPC_STATUS = TagKey.create((String)"canonical_status");
    @VisibleForTesting
    static final TagKey RPC_METHOD = TagKey.create((String)"method");
    @VisibleForTesting
    static final TagKey GRPC_CLIENT_STATUS = TagKey.create((String)"grpc_client_status");
    @VisibleForTesting
    static final TagKey GRPC_CLIENT_METHOD = TagKey.create((String)"grpc_client_method");
    @VisibleForTesting
    static final TagKey GRPC_SERVER_STATUS = TagKey.create((String)"grpc_server_status");
    @VisibleForTesting
    static final TagKey GRPC_SERVER_METHOD = TagKey.create((String)"grpc_server_method");
    private static final Map<TagKey, TagKey[]> RPC_TAG_MAPPINGS = ImmutableMap.builder().put((Object)RPC_STATUS, (Object)new TagKey[]{GRPC_CLIENT_STATUS, GRPC_SERVER_STATUS}).put((Object)RPC_METHOD, (Object)new TagKey[]{GRPC_CLIENT_METHOD, GRPC_SERVER_METHOD}).build();
    private static final Function<Measurement.MeasurementDouble, Double> GET_VALUE_FROM_MEASUREMENT_DOUBLE = new Function<Measurement.MeasurementDouble, Double>(){

        public Double apply(Measurement.MeasurementDouble arg) {
            return arg.getValue();
        }
    };
    private static final Function<Measurement.MeasurementLong, Double> GET_VALUE_FROM_MEASUREMENT_LONG = new Function<Measurement.MeasurementLong, Double>(){

        public Double apply(Measurement.MeasurementLong arg) {
            return arg.getValue();
        }
    };

    static Map<TagKey, TagValueWithMetadata> getTagMap(TagContext ctx) {
        if (ctx instanceof TagMapImpl) {
            return ((TagMapImpl)ctx).getTags();
        }
        HashMap tags = Maps.newHashMap();
        Iterator i = InternalUtils.getTags((TagContext)ctx);
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            tags.put(tag.getKey(), TagValueWithMetadata.create(tag.getValue(), tag.getTagMetadata()));
        }
        return tags;
    }

    @VisibleForTesting
    static List<TagValue> getTagValues(Map<? extends TagKey, TagValueWithMetadata> tags, List<? extends TagKey> columns) {
        ArrayList<TagValue> tagValues = new ArrayList<TagValue>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            TagKey tagKey = columns.get(i);
            if (!tags.containsKey(tagKey)) {
                TagValue tagValue = UNKNOWN_TAG_VALUE;
                TagKey[] newKeys = RPC_TAG_MAPPINGS.get(tagKey);
                if (newKeys != null) {
                    tagValue = RecordUtils.getTagValueForDeprecatedRpcTag(tags, newKeys);
                }
                tagValues.add(tagValue);
                continue;
            }
            tagValues.add(tags.get(tagKey).getTagValue());
        }
        return tagValues;
    }

    @Nullable
    private static TagValue getTagValueForDeprecatedRpcTag(Map<? extends TagKey, TagValueWithMetadata> tags, TagKey[] newKeys) {
        for (TagKey newKey : newKeys) {
            TagValueWithMetadata valueWithMetadata = tags.get(newKey);
            if (valueWithMetadata == null) continue;
            return valueWithMetadata.getTagValue();
        }
        return UNKNOWN_TAG_VALUE;
    }

    @VisibleForTesting
    static MutableAggregation createMutableAggregation(Aggregation aggregation, final Measure measure) {
        return (MutableAggregation)aggregation.match((Function)new Function<Aggregation.Sum, MutableAggregation>(){

            public MutableAggregation apply(Aggregation.Sum arg) {
                return (MutableAggregation)measure.match((Function)CreateMutableSumDouble.INSTANCE, (Function)CreateMutableSumLong.INSTANCE, Functions.throwAssertionError());
            }
        }, (Function)CreateMutableCount.INSTANCE, (Function)CreateMutableDistribution.INSTANCE, (Function)new Function<Aggregation.LastValue, MutableAggregation>(){

            public MutableAggregation apply(Aggregation.LastValue arg) {
                return (MutableAggregation)measure.match((Function)CreateMutableLastValueDouble.INSTANCE, (Function)CreateMutableLastValueLong.INSTANCE, Functions.throwAssertionError());
            }
        }, (Function)AggregationDefaultFunction.INSTANCE);
    }

    static <T> Map<T, AggregationData> createAggregationMap(Map<T, MutableAggregation> tagValueAggregationMap, Measure measure) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<T, MutableAggregation> entry : tagValueAggregationMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toAggregationData());
        }
        return map;
    }

    static double getDoubleValueFromMeasurement(Measurement measurement) {
        return (Double)measurement.match(GET_VALUE_FROM_MEASUREMENT_DOUBLE, GET_VALUE_FROM_MEASUREMENT_LONG, Functions.throwAssertionError());
    }

    private RecordUtils() {
    }

    private static final class CreateMutableLastValueLong
    implements Function<Measure.MeasureLong, MutableAggregation> {
        private static final CreateMutableLastValueLong INSTANCE = new CreateMutableLastValueLong();

        private CreateMutableLastValueLong() {
        }

        public MutableAggregation apply(Measure.MeasureLong arg) {
            return MutableAggregation.MutableLastValueLong.create();
        }
    }

    private static final class CreateMutableLastValueDouble
    implements Function<Measure.MeasureDouble, MutableAggregation> {
        private static final CreateMutableLastValueDouble INSTANCE = new CreateMutableLastValueDouble();

        private CreateMutableLastValueDouble() {
        }

        public MutableAggregation apply(Measure.MeasureDouble arg) {
            return MutableAggregation.MutableLastValueDouble.create();
        }
    }

    private static final class CreateMutableDistribution
    implements Function<Aggregation.Distribution, MutableAggregation> {
        private static final CreateMutableDistribution INSTANCE = new CreateMutableDistribution();

        private CreateMutableDistribution() {
        }

        public MutableAggregation apply(Aggregation.Distribution arg) {
            return MutableAggregation.MutableDistribution.create(arg.getBucketBoundaries());
        }
    }

    private static final class AggregationDefaultFunction
    implements Function<Aggregation, MutableAggregation> {
        private static final AggregationDefaultFunction INSTANCE = new AggregationDefaultFunction();

        private AggregationDefaultFunction() {
        }

        public MutableAggregation apply(Aggregation arg) {
            if (arg instanceof Aggregation.Mean) {
                return MutableAggregation.MutableMean.create();
            }
            throw new IllegalArgumentException("Unknown Aggregation.");
        }
    }

    private static final class CreateMutableCount
    implements Function<Aggregation.Count, MutableAggregation> {
        private static final CreateMutableCount INSTANCE = new CreateMutableCount();

        private CreateMutableCount() {
        }

        public MutableAggregation apply(Aggregation.Count arg) {
            return MutableAggregation.MutableCount.create();
        }
    }

    private static final class CreateMutableSumLong
    implements Function<Measure.MeasureLong, MutableAggregation> {
        private static final CreateMutableSumLong INSTANCE = new CreateMutableSumLong();

        private CreateMutableSumLong() {
        }

        public MutableAggregation apply(Measure.MeasureLong arg) {
            return MutableAggregation.MutableSumLong.create();
        }
    }

    private static final class CreateMutableSumDouble
    implements Function<Measure.MeasureDouble, MutableAggregation> {
        private static final CreateMutableSumDouble INSTANCE = new CreateMutableSumDouble();

        private CreateMutableSumDouble() {
        }

        public MutableAggregation apply(Measure.MeasureDouble arg) {
            return MutableAggregation.MutableSumDouble.create();
        }
    }
}

