/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.unsafe.ContextUtils;

final class CurrentTagMapUtils {
    private CurrentTagMapUtils() {
    }

    static TagContext getCurrentTagMap() {
        return (TagContext)ContextUtils.TAG_CONTEXT_KEY.get();
    }

    static Scope withTagMap(TagContext tags) {
        return new WithTagMap(tags);
    }

    private static final class WithTagMap
    implements Scope {
        private final Context orig;

        private WithTagMap(TagContext tags) {
            this.orig = Context.current().withValue(ContextUtils.TAG_CONTEXT_KEY, (Object)tags).attach();
        }

        public void close() {
            Context.current().detach(this.orig);
        }
    }
}

