/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags.propagation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.opencensus.implcore.internal.VarInt;
import io.opencensus.implcore.tags.TagMapImpl;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import io.opencensus.tags.propagation.TagContextSerializationException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class SerializationUtils {
    @VisibleForTesting
    static final int VERSION_ID = 0;
    @VisibleForTesting
    static final int TAG_FIELD_ID = 0;
    @VisibleForTesting
    static final int TAGCONTEXT_SERIALIZED_SIZE_LIMIT = 8192;

    private SerializationUtils() {
    }

    static byte[] serializeBinary(TagContext tags) throws TagContextSerializationException {
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.write(0);
        int totalChars = 0;
        Iterator i = InternalUtils.getTags((TagContext)tags);
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            totalChars += tag.getKey().getName().length();
            totalChars += tag.getValue().asString().length();
            SerializationUtils.encodeTag(tag, byteArrayDataOutput);
        }
        if (totalChars > 8192) {
            throw new TagContextSerializationException("Size of TagContext exceeds the maximum serialized size 8192");
        }
        return byteArrayDataOutput.toByteArray();
    }

    static TagMapImpl deserializeBinary(byte[] bytes) throws TagContextDeserializationException {
        try {
            if (bytes.length == 0) {
                throw new TagContextDeserializationException("Input byte[] can not be empty.");
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
            byte versionId = buffer.get();
            if (versionId > 0 || versionId < 0) {
                throw new TagContextDeserializationException("Wrong Version ID: " + versionId + ". Currently supports version up to: " + 0);
            }
            return new TagMapImpl(SerializationUtils.parseTags(buffer));
        }
        catch (BufferUnderflowException exn) {
            throw new TagContextDeserializationException(exn.toString());
        }
    }

    private static Map<TagKey, TagValue> parseTags(ByteBuffer buffer) throws TagContextDeserializationException {
        byte type;
        HashMap<TagKey, TagValue> tags = new HashMap<TagKey, TagValue>();
        int limit = buffer.limit();
        int totalChars = 0;
        while (buffer.position() < limit && (type = buffer.get()) == 0) {
            TagKey key = SerializationUtils.createTagKey(SerializationUtils.decodeString(buffer));
            TagValue val = SerializationUtils.createTagValue(key, SerializationUtils.decodeString(buffer));
            totalChars += key.getName().length();
            totalChars += val.asString().length();
            tags.put(key, val);
        }
        if (totalChars > 8192) {
            throw new TagContextDeserializationException("Size of TagContext exceeds the maximum serialized size 8192");
        }
        return tags;
    }

    private static final TagKey createTagKey(String name) throws TagContextDeserializationException {
        try {
            return TagKey.create((String)name);
        }
        catch (IllegalArgumentException e) {
            throw new TagContextDeserializationException("Invalid tag key: " + name, (Throwable)e);
        }
    }

    private static final TagValue createTagValue(TagKey key, String value) throws TagContextDeserializationException {
        try {
            return TagValue.create((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new TagContextDeserializationException("Invalid tag value for key " + key + ": " + value, (Throwable)e);
        }
    }

    private static final void encodeTag(Tag tag, ByteArrayDataOutput byteArrayDataOutput) {
        byteArrayDataOutput.write(0);
        SerializationUtils.encodeString(tag.getKey().getName(), byteArrayDataOutput);
        SerializationUtils.encodeString(tag.getValue().asString(), byteArrayDataOutput);
    }

    private static final void encodeString(String input, ByteArrayDataOutput byteArrayDataOutput) {
        SerializationUtils.putVarInt(input.length(), byteArrayDataOutput);
        byteArrayDataOutput.write(input.getBytes(Charsets.UTF_8));
    }

    private static final void putVarInt(int input, ByteArrayDataOutput byteArrayDataOutput) {
        byte[] output = new byte[VarInt.varIntSize(input)];
        VarInt.putVarInt(input, output, 0);
        byteArrayDataOutput.write(output);
    }

    private static final String decodeString(ByteBuffer buffer) {
        int length = VarInt.getVarInt(buffer);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)buffer.get());
        }
        return builder.toString();
    }
}

