/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace;

import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.trace.RecordEventsSpanImpl;
import io.opencensus.implcore.trace.export.RunningSpanStoreImpl;
import io.opencensus.implcore.trace.export.SampledSpanStoreImpl;
import io.opencensus.implcore.trace.export.SpanExporterImpl;
import io.opencensus.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StartEndHandlerImpl
implements RecordEventsSpanImpl.StartEndHandler {
    private final SpanExporterImpl spanExporter;
    @Nullable
    private final RunningSpanStoreImpl runningSpanStore;
    @Nullable
    private final SampledSpanStoreImpl sampledSpanStore;
    private final EventQueue eventQueue;
    private final boolean enqueueEventForNonSampledSpans;

    public StartEndHandlerImpl(SpanExporterImpl spanExporter, @Nullable RunningSpanStoreImpl runningSpanStore, @Nullable SampledSpanStoreImpl sampledSpanStore, EventQueue eventQueue) {
        this.spanExporter = spanExporter;
        this.runningSpanStore = runningSpanStore;
        this.sampledSpanStore = sampledSpanStore;
        this.enqueueEventForNonSampledSpans = runningSpanStore != null || sampledSpanStore != null;
        this.eventQueue = eventQueue;
    }

    @Override
    public void onStart(RecordEventsSpanImpl span) {
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS) && this.enqueueEventForNonSampledSpans) {
            this.eventQueue.enqueue(new SpanStartEvent(span, this.runningSpanStore));
        }
    }

    @Override
    public void onEnd(RecordEventsSpanImpl span) {
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS) && this.enqueueEventForNonSampledSpans || span.getContext().getTraceOptions().isSampled()) {
            this.eventQueue.enqueue(new SpanEndEvent(span, this.spanExporter, this.runningSpanStore, this.sampledSpanStore));
        }
    }

    private static final class SpanEndEvent
    implements EventQueue.Entry {
        private final RecordEventsSpanImpl span;
        @Nullable
        private final RunningSpanStoreImpl runningSpanStore;
        private final SpanExporterImpl spanExporter;
        @Nullable
        private final SampledSpanStoreImpl sampledSpanStore;

        SpanEndEvent(RecordEventsSpanImpl span, SpanExporterImpl spanExporter, @Nullable RunningSpanStoreImpl runningSpanStore, @Nullable SampledSpanStoreImpl sampledSpanStore) {
            this.span = span;
            this.runningSpanStore = runningSpanStore;
            this.spanExporter = spanExporter;
            this.sampledSpanStore = sampledSpanStore;
        }

        @Override
        public void process() {
            if (this.span.getContext().getTraceOptions().isSampled()) {
                this.spanExporter.addSpan(this.span);
            }
            if (this.runningSpanStore != null) {
                this.runningSpanStore.onEnd(this.span);
            }
            if (this.sampledSpanStore != null) {
                this.sampledSpanStore.considerForSampling(this.span);
            }
        }
    }

    private static final class SpanStartEvent
    implements EventQueue.Entry {
        private final RecordEventsSpanImpl span;
        @Nullable
        private final RunningSpanStoreImpl activeSpansExporter;

        SpanStartEvent(RecordEventsSpanImpl span, @Nullable RunningSpanStoreImpl activeSpansExporter) {
            this.span = span;
            this.activeSpansExporter = activeSpansExporter;
        }

        @Override
        public void process() {
            if (this.activeSpansExporter != null) {
                this.activeSpansExporter.onStart(this.span);
            }
        }
    }
}

