/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.temporary.metrics;

import io.opencensus.common.Function;
import io.opencensus.implcore.temporary.metrics.AutoValue_Value_ValueDistribution;
import io.opencensus.implcore.temporary.metrics.AutoValue_Value_ValueDouble;
import io.opencensus.implcore.temporary.metrics.AutoValue_Value_ValueLong;
import io.opencensus.implcore.temporary.metrics.Distribution;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Value {
    Value() {
    }

    public static Value doubleValue(double value) {
        return ValueDouble.create(value);
    }

    public static Value longValue(long value) {
        return ValueLong.create(value);
    }

    public static Value distributionValue(Distribution value) {
        return ValueDistribution.create(value);
    }

    public abstract <T> T match(Function<? super Double, T> var1, Function<? super Long, T> var2, Function<? super Distribution, T> var3, Function<? super Value, T> var4);

    @Immutable
    static abstract class ValueDistribution
    extends Value {
        ValueDistribution() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Value, T> defaultFunction) {
            return (T)distributionFunction.apply((Object)this.getValue());
        }

        static ValueDistribution create(Distribution value) {
            return new AutoValue_Value_ValueDistribution(value);
        }

        abstract Distribution getValue();
    }

    @Immutable
    static abstract class ValueLong
    extends Value {
        ValueLong() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Value, T> defaultFunction) {
            return (T)longFunction.apply((Object)this.getValue());
        }

        static ValueLong create(long value) {
            return new AutoValue_Value_ValueLong(value);
        }

        abstract long getValue();
    }

    @Immutable
    static abstract class ValueDouble
    extends Value {
        ValueDouble() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Value, T> defaultFunction) {
            return (T)doubleFunction.apply((Object)this.getValue());
        }

        static ValueDouble create(double value) {
            return new AutoValue_Value_ValueDouble(value);
        }

        abstract double getValue();
    }
}

