/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.temporary.metrics;

import io.opencensus.implcore.temporary.metrics.AutoValue_Metric;
import io.opencensus.implcore.temporary.metrics.MetricDescriptor;
import io.opencensus.implcore.temporary.metrics.Point;
import io.opencensus.implcore.temporary.metrics.TimeSeries;
import io.opencensus.implcore.temporary.metrics.Value;
import io.opencensus.internal.Utils;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Metric {
    Metric() {
    }

    public static Metric create(MetricDescriptor metricDescriptor, List<TimeSeries> timeSeriesList) {
        Metric.checkTypeMatch(metricDescriptor.getType(), timeSeriesList);
        return new AutoValue_Metric(metricDescriptor, timeSeriesList);
    }

    public abstract MetricDescriptor getMetricDescriptor();

    public abstract List<TimeSeries> getTimeSeriesList();

    private static void checkTypeMatch(MetricDescriptor.Type type, List<TimeSeries> timeSeriesList) {
        for (TimeSeries timeSeries : timeSeriesList) {
            for (Point point : timeSeries.getPoints()) {
                Value value = point.getValue();
                String valueClassName = "";
                if (value.getClass().getSuperclass() != null) {
                    valueClassName = value.getClass().getSuperclass().getSimpleName();
                }
                switch (type) {
                    case GAUGE_INT64: 
                    case CUMULATIVE_INT64: {
                        Utils.checkArgument((boolean)(value instanceof Value.ValueLong), (String)"Type mismatch: %s, %s.", (Object[])new Object[]{type, valueClassName});
                        break;
                    }
                    case CUMULATIVE_DOUBLE: 
                    case GAUGE_DOUBLE: {
                        Utils.checkArgument((boolean)(value instanceof Value.ValueDouble), (String)"Type mismatch: %s, %s.", (Object[])new Object[]{type, valueClassName});
                        break;
                    }
                    case CUMULATIVE_DISTRIBUTION: {
                        Utils.checkArgument((boolean)(value instanceof Value.ValueDistribution), (String)"Type mismatch: %s, %s.", (Object[])new Object[]{type, valueClassName});
                    }
                }
            }
        }
    }
}

