/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.temporary.metrics;

import io.opencensus.implcore.temporary.metrics.Distribution;
import java.util.List;

final class AutoValue_Distribution
extends Distribution {
    private final double mean;
    private final long count;
    private final double sumOfSquaredDeviations;
    private final List<Double> bucketBoundaries;
    private final List<Distribution.Bucket> buckets;

    AutoValue_Distribution(double mean, long count, double sumOfSquaredDeviations, List<Double> bucketBoundaries, List<Distribution.Bucket> buckets) {
        this.mean = mean;
        this.count = count;
        this.sumOfSquaredDeviations = sumOfSquaredDeviations;
        if (bucketBoundaries == null) {
            throw new NullPointerException("Null bucketBoundaries");
        }
        this.bucketBoundaries = bucketBoundaries;
        if (buckets == null) {
            throw new NullPointerException("Null buckets");
        }
        this.buckets = buckets;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getSumOfSquaredDeviations() {
        return this.sumOfSquaredDeviations;
    }

    @Override
    public List<Double> getBucketBoundaries() {
        return this.bucketBoundaries;
    }

    @Override
    public List<Distribution.Bucket> getBuckets() {
        return this.buckets;
    }

    public String toString() {
        return "Distribution{mean=" + this.mean + ", count=" + this.count + ", sumOfSquaredDeviations=" + this.sumOfSquaredDeviations + ", bucketBoundaries=" + this.bucketBoundaries + ", buckets=" + this.buckets + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Distribution) {
            Distribution that = (Distribution)o;
            return Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(that.getMean()) && this.count == that.getCount() && Double.doubleToLongBits(this.sumOfSquaredDeviations) == Double.doubleToLongBits(that.getSumOfSquaredDeviations()) && this.bucketBoundaries.equals(that.getBucketBoundaries()) && this.buckets.equals(that.getBuckets());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (Double.doubleToLongBits(this.mean) >>> 32 ^ Double.doubleToLongBits(this.mean)));
        h *= 1000003;
        h = (int)((long)h ^ (this.count >>> 32 ^ this.count));
        h *= 1000003;
        h = (int)((long)h ^ (Double.doubleToLongBits(this.sumOfSquaredDeviations) >>> 32 ^ Double.doubleToLongBits(this.sumOfSquaredDeviations)));
        h *= 1000003;
        h ^= this.bucketBoundaries.hashCode();
        h *= 1000003;
        return h ^= this.buckets.hashCode();
    }
}

