/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import com.google.common.base.Preconditions;
import io.opencensus.common.Scope;
import io.opencensus.implcore.tags.CurrentTagContextUtils;
import io.opencensus.implcore.tags.TagContextImpl;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.HashMap;
import java.util.Map;

final class TagContextBuilderImpl
extends TagContextBuilder {
    private final Map<TagKey, TagValue> tags;

    TagContextBuilderImpl(Map<TagKey, TagValue> tags) {
        this.tags = new HashMap<TagKey, TagValue>(tags);
    }

    TagContextBuilderImpl() {
        this.tags = new HashMap<TagKey, TagValue>();
    }

    public TagContextBuilderImpl put(TagKey key, TagValue value) {
        this.tags.put((TagKey)Preconditions.checkNotNull((Object)key, (Object)"key"), (TagValue)Preconditions.checkNotNull((Object)value, (Object)"value"));
        return this;
    }

    public TagContextBuilderImpl remove(TagKey key) {
        this.tags.remove(Preconditions.checkNotNull((Object)key, (Object)"key"));
        return this;
    }

    public TagContextImpl build() {
        return new TagContextImpl(this.tags);
    }

    public Scope buildScoped() {
        return CurrentTagContextUtils.withTagContext(this.build());
    }
}

