/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import io.opencensus.implcore.stats.MeasureMapInternal;
import io.opencensus.implcore.stats.StatsManager;
import io.opencensus.stats.Measure;
import io.opencensus.stats.MeasureMap;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.unsafe.ContextUtils;

final class MeasureMapImpl
extends MeasureMap {
    private final StatsManager statsManager;
    private final MeasureMapInternal.Builder builder = MeasureMapInternal.builder();

    static MeasureMapImpl create(StatsManager statsManager) {
        return new MeasureMapImpl(statsManager);
    }

    private MeasureMapImpl(StatsManager statsManager) {
        this.statsManager = statsManager;
    }

    public MeasureMapImpl put(Measure.MeasureDouble measure, double value) {
        this.builder.put(measure, value);
        return this;
    }

    public MeasureMapImpl put(Measure.MeasureLong measure, long value) {
        this.builder.put(measure, value);
        return this;
    }

    public MeasureMap putAttachment(String key, String value) {
        this.builder.putAttachment(key, value);
        return this;
    }

    public void record() {
        this.record((TagContext)ContextUtils.TAG_CONTEXT_KEY.get());
    }

    public void record(TagContext tags) {
        this.statsManager.record(tags, this.builder.build());
    }
}

