/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.export;

import io.opencensus.common.Duration;
import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.trace.export.RunningSpanStoreImpl;
import io.opencensus.implcore.trace.export.SampledSpanStoreImpl;
import io.opencensus.implcore.trace.export.SpanExporterImpl;
import io.opencensus.trace.export.ExportComponent;
import javax.annotation.Nullable;

public final class ExportComponentImpl
extends ExportComponent {
    private static final int EXPORTER_BUFFER_SIZE = 32;
    private static final Duration EXPORTER_SCHEDULE_DELAY = Duration.create((long)5L, (int)0);
    private final SpanExporterImpl spanExporter = SpanExporterImpl.create(32, EXPORTER_SCHEDULE_DELAY);
    @Nullable
    private final RunningSpanStoreImpl runningSpanStore;
    @Nullable
    private final SampledSpanStoreImpl sampledSpanStore;

    public SpanExporterImpl getSpanExporter() {
        return this.spanExporter;
    }

    @Nullable
    public RunningSpanStoreImpl getRunningSpanStore() {
        return this.runningSpanStore;
    }

    @Nullable
    public SampledSpanStoreImpl getSampledSpanStore() {
        return this.sampledSpanStore;
    }

    public static ExportComponentImpl createWithInProcessStores(EventQueue eventQueue) {
        return new ExportComponentImpl(true, eventQueue);
    }

    public static ExportComponentImpl createWithoutInProcessStores(EventQueue eventQueue) {
        return new ExportComponentImpl(false, eventQueue);
    }

    private ExportComponentImpl(boolean supportInProcessStores, EventQueue eventQueue) {
        this.runningSpanStore = supportInProcessStores ? new RunningSpanStoreImpl() : null;
        this.sampledSpanStore = supportInProcessStores ? new SampledSpanStoreImpl(eventQueue) : null;
    }
}

