/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.zipkin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.zipkin.ZipkinExporterConfiguration;
import io.opencensus.exporter.trace.zipkin.ZipkinExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public final class ZipkinTraceExporter {
    private static final String REGISTER_NAME = ZipkinTraceExporter.class.getName();
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private ZipkinTraceExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(ZipkinExporterConfiguration configuration) {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Zipkin exporter is already registered.");
            Sender sender = configuration.getSender();
            if (sender == null) {
                sender = URLConnectionSender.create((String)configuration.getV2Url());
            }
            ZipkinExporterHandler newHandler = new ZipkinExporterHandler(configuration.getEncoder(), sender, configuration.getServiceName(), configuration.getDeadline());
            handler = newHandler;
            ZipkinTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), (SpanExporter.Handler)newHandler);
        }
    }

    @Deprecated
    public static void createAndRegister(String v2Url, String serviceName) {
        ZipkinTraceExporter.createAndRegister(ZipkinExporterConfiguration.builder().setV2Url(v2Url).setServiceName(serviceName).build());
    }

    @Deprecated
    public static void createAndRegister(SpanBytesEncoder encoder, Sender sender, String serviceName) {
        ZipkinTraceExporter.createAndRegister(ZipkinExporterConfiguration.builder().setSender(sender).setEncoder(encoder).setServiceName(serviceName).build());
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Zipkin exporter is not registered.");
            ZipkinTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

