/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.zipkin;

import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Scope;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;

final class ZipkinExporterHandler
extends SpanExporter.Handler {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Sampler probabilitySampler = Samplers.probabilitySampler((double)1.0E-4);
    private static final Logger logger = Logger.getLogger(ZipkinExporterHandler.class.getName());
    private static final String STATUS_CODE = "census.status_code";
    private static final String STATUS_DESCRIPTION = "census.status_description";
    private final SpanBytesEncoder encoder;
    private final Sender sender;
    private final Endpoint localEndpoint;
    private static final Function<Object, String> returnToString = Functions.returnToString();

    ZipkinExporterHandler(SpanBytesEncoder encoder, Sender sender, String serviceName) {
        this.encoder = encoder;
        this.sender = sender;
        this.localEndpoint = ZipkinExporterHandler.produceLocalEndpoint(serviceName);
    }

    static Endpoint produceLocalEndpoint(String serviceName) {
        Endpoint.Builder builder;
        block5: {
            builder = Endpoint.newBuilder().serviceName(serviceName);
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                if (nics == null) {
                    return builder.build();
                }
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        builder.ip(address);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    static Span generateSpan(SpanData spanData, Endpoint localEndpoint) {
        SpanContext context = spanData.getContext();
        long startTimestamp = ZipkinExporterHandler.toEpochMicros(spanData.getStartTimestamp());
        long endTimestamp = ZipkinExporterHandler.toEpochMicros(spanData.getEndTimestamp());
        Span.Builder spanBuilder = Span.newBuilder().traceId(context.getTraceId().toLowerBase16()).id(context.getSpanId().toLowerBase16()).kind(ZipkinExporterHandler.toSpanKind(spanData)).name(spanData.getName()).timestamp(ZipkinExporterHandler.toEpochMicros(spanData.getStartTimestamp())).duration(endTimestamp - startTimestamp).localEndpoint(localEndpoint);
        if (spanData.getParentSpanId() != null && spanData.getParentSpanId().isValid()) {
            spanBuilder.parentId(spanData.getParentSpanId().toLowerBase16());
        }
        for (Map.Entry label : spanData.getAttributes().getAttributeMap().entrySet()) {
            spanBuilder.putTag((String)label.getKey(), ZipkinExporterHandler.attributeValueToString((AttributeValue)label.getValue()));
        }
        Status status = spanData.getStatus();
        if (status != null) {
            spanBuilder.putTag(STATUS_CODE, status.getCanonicalCode().toString());
            if (status.getDescription() != null) {
                spanBuilder.putTag(STATUS_DESCRIPTION, status.getDescription());
            }
        }
        for (SpanData.TimedEvent annotation : spanData.getAnnotations().getEvents()) {
            spanBuilder.addAnnotation(ZipkinExporterHandler.toEpochMicros(annotation.getTimestamp()), ((Annotation)annotation.getEvent()).getDescription());
        }
        for (SpanData.TimedEvent messageEvent : spanData.getMessageEvents().getEvents()) {
            spanBuilder.addAnnotation(ZipkinExporterHandler.toEpochMicros(messageEvent.getTimestamp()), ((MessageEvent)messageEvent.getEvent()).getType().name());
        }
        return spanBuilder.build();
    }

    @Nullable
    private static Span.Kind toSpanKind(SpanData spanData) {
        if (spanData.getKind() == Span.Kind.SERVER || spanData.getKind() == null && Boolean.TRUE.equals(spanData.getHasRemoteParent())) {
            return Span.Kind.SERVER;
        }
        if (spanData.getKind() == Span.Kind.CLIENT || spanData.getName().startsWith("Sent.")) {
            return Span.Kind.CLIENT;
        }
        return null;
    }

    private static long toEpochMicros(Timestamp timestamp) {
        return TimeUnit.SECONDS.toMicros(timestamp.getSeconds()) + TimeUnit.NANOSECONDS.toMicros(timestamp.getNanos());
    }

    private static String attributeValueToString(AttributeValue attributeValue) {
        return (String)attributeValue.match(returnToString, returnToString, returnToString, returnToString, Functions.returnConstant((Object)""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Collection<SpanData> spanDataList) {
        Scope scope = tracer.spanBuilder("SendZipkinSpans").setSampler(probabilitySampler).startScopedSpan();
        try {
            ArrayList<byte[]> encodedSpans = new ArrayList<byte[]>(spanDataList.size());
            for (SpanData spanData : spanDataList) {
                encodedSpans.add(this.encoder.encode((Object)ZipkinExporterHandler.generateSpan(spanData, this.localEndpoint)));
            }
            try {
                this.sender.sendSpans(encodedSpans).execute();
            }
            catch (IOException e) {
                tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription(e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
                throw new RuntimeException(e);
            }
        }
        finally {
            scope.close();
        }
    }
}

