/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.auth.Credentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.stackdriver.AutoValue_StackdriverTraceConfiguration;
import io.opencensus.trace.AttributeValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class StackdriverTraceConfiguration {
    private static final String DEFAULT_PROJECT_ID = Strings.nullToEmpty((String)ServiceOptions.getDefaultProjectId());
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create((long)10L, (int)0);

    StackdriverTraceConfiguration() {
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getProjectId();

    @Nullable
    public abstract TraceServiceStub getTraceServiceStub();

    public abstract Map<String, AttributeValue> getFixedAttributes();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_StackdriverTraceConfiguration.Builder().setProjectId(DEFAULT_PROJECT_ID).setFixedAttributes(Collections.emptyMap()).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.fromMillis((long)0L);

        Builder() {
        }

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setTraceServiceStub(TraceServiceStub var1);

        public abstract Builder setFixedAttributes(Map<String, AttributeValue> var1);

        public abstract Builder setDeadline(Duration var1);

        abstract String getProjectId();

        abstract Map<String, AttributeValue> getFixedAttributes();

        abstract Duration getDeadline();

        abstract StackdriverTraceConfiguration autoBuild();

        public StackdriverTraceConfiguration build() {
            this.setFixedAttributes(Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(this.getFixedAttributes())));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getProjectId()) ? 1 : 0) != 0, (Object)"Cannot find a project ID from either configurations or application default.");
            for (Map.Entry<String, AttributeValue> fixedAttribute : this.getFixedAttributes().entrySet()) {
                Preconditions.checkNotNull((Object)fixedAttribute.getKey(), (Object)"attribute key");
                Preconditions.checkNotNull((Object)fixedAttribute.getValue(), (Object)"attribute value");
            }
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

