/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceConfiguration;
import io.opencensus.exporter.trace.stackdriver.StackdriverV2ExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class StackdriverTraceExporter {
    private static final String REGISTER_NAME = StackdriverTraceExporter.class.getName();
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(StackdriverTraceConfiguration configuration) throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Stackdriver exporter is already registered.");
            Credentials credentials = configuration.getCredentials();
            String projectId = configuration.getProjectId();
            TraceServiceStub stub = configuration.getTraceServiceStub();
            StackdriverV2ExporterHandler handler = stub == null ? StackdriverV2ExporterHandler.createWithCredentials(projectId, (Credentials)(credentials != null ? credentials : GoogleCredentials.getApplicationDefault()), configuration.getFixedAttributes()) : StackdriverV2ExporterHandler.createWithStub(projectId, TraceServiceClient.create((TraceServiceStub)stub), configuration.getFixedAttributes());
            StackdriverTraceExporter.registerInternal(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerInternal(SpanExporter.Handler newHandler) {
        Object object = monitor;
        synchronized (object) {
            handler = newHandler;
            StackdriverTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), newHandler);
        }
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Stackdriver exporter is not registered.");
            StackdriverTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }

    private StackdriverTraceExporter() {
    }
}

