/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.ocagent.OcAgentNodeUtils;
import io.opencensus.exporter.trace.ocagent.OcAgentTraceServiceExportRpcHandler;
import io.opencensus.exporter.trace.ocagent.TraceProtoUtils;
import io.opencensus.proto.agent.common.v1.Node;
import io.opencensus.proto.agent.trace.v1.ExportTraceServiceRequest;
import io.opencensus.proto.agent.trace.v1.TraceServiceGrpc;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class OcAgentTraceExporterHandler
extends SpanExporter.Handler {
    private static final Logger logger = Logger.getLogger(OcAgentTraceExporterHandler.class.getName());
    @VisibleForTesting
    static final String DEFAULT_END_POINT = "localhost:55678";
    private static final String DEFAULT_SERVICE_NAME = "OpenCensus";
    private final String endPoint;
    private final Node node;
    private final Boolean useInsecure;
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private OcAgentTraceServiceExportRpcHandler exportRpcHandler;

    OcAgentTraceExporterHandler() {
        this(null, null, null, null, null, true);
    }

    OcAgentTraceExporterHandler(@Nullable String endPoint, @Nullable String serviceName, @Nullable Boolean useInsecure, @Nullable SslContext sslContext, @Nullable Duration retryInterval, boolean enableConfig) {
        if (endPoint == null) {
            endPoint = DEFAULT_END_POINT;
        }
        if (serviceName == null) {
            serviceName = DEFAULT_SERVICE_NAME;
        }
        if (useInsecure == null) {
            useInsecure = false;
        }
        this.endPoint = endPoint;
        this.node = OcAgentNodeUtils.getNodeInfo(serviceName);
        this.useInsecure = useInsecure;
        this.sslContext = sslContext;
    }

    public void export(Collection<SpanData> spanDataList) {
        if (this.exportRpcHandler == null || this.exportRpcHandler.isCompleted()) {
            TraceServiceGrpc.TraceServiceStub stub = OcAgentTraceExporterHandler.getTraceServiceStub(this.endPoint, this.useInsecure, this.sslContext);
            this.exportRpcHandler = OcAgentTraceExporterHandler.createExportRpcHandlerAndConnect(stub, this.node);
        }
        if (this.exportRpcHandler == null || this.exportRpcHandler.isCompleted()) {
            logger.info("Export RPC disconnected, dropping " + spanDataList.size() + " spans.");
            this.exportRpcHandler = null;
        } else {
            ExportTraceServiceRequest.Builder requestBuilder = ExportTraceServiceRequest.newBuilder();
            for (SpanData spanData : spanDataList) {
                requestBuilder.addSpans(TraceProtoUtils.toSpanProto(spanData));
            }
            this.exportRpcHandler.onExport(requestBuilder.build());
        }
    }

    @Nullable
    private static OcAgentTraceServiceExportRpcHandler createExportRpcHandlerAndConnect(TraceServiceGrpc.TraceServiceStub stub, Node node) {
        OcAgentTraceServiceExportRpcHandler exportRpcHandler;
        block2: {
            exportRpcHandler = null;
            try {
                exportRpcHandler = OcAgentTraceServiceExportRpcHandler.create(stub);
                ExportTraceServiceRequest firstExportReq = ExportTraceServiceRequest.newBuilder().setNode(node).build();
                exportRpcHandler.onExport(firstExportReq);
            }
            catch (RuntimeException e) {
                if (exportRpcHandler == null) break block2;
                exportRpcHandler.onComplete(e);
            }
        }
        return exportRpcHandler;
    }

    private static TraceServiceGrpc.TraceServiceStub getTraceServiceStub(String endPoint, Boolean useInsecure, SslContext sslContext) {
        Object channelBuilder = useInsecure != false ? ManagedChannelBuilder.forTarget((String)endPoint).usePlaintext() : NettyChannelBuilder.forTarget((String)endPoint).negotiationType(NegotiationType.TLS).sslContext(sslContext);
        ManagedChannel channel = channelBuilder.build();
        return TraceServiceGrpc.newStub((Channel)channel);
    }
}

