/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.ocagent.OcAgentTraceExporterConfiguration;
import io.opencensus.exporter.trace.ocagent.OcAgentTraceExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OcAgentTraceExporter {
    private static final Object monitor = new Object();
    private static final String REGISTER_NAME = OcAgentTraceExporter.class.getName();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private OcAgentTraceExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"OC-Agent exporter is already registered.");
            OcAgentTraceExporterHandler newHandler = new OcAgentTraceExporterHandler();
            OcAgentTraceExporter.registerInternal(newHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(OcAgentTraceExporterConfiguration configuration) {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"OC-Agent exporter is already registered.");
            OcAgentTraceExporterHandler newHandler = new OcAgentTraceExporterHandler(configuration.getEndPoint(), configuration.getServiceName(), configuration.getUseInsecure(), configuration.getSslContext(), configuration.getRetryInterval(), configuration.getEnableConfig());
            OcAgentTraceExporter.registerInternal(newHandler);
        }
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerInternal(SpanExporter.Handler newHandler) {
        Object object = monitor;
        synchronized (object) {
            handler = newHandler;
            OcAgentTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), newHandler);
        }
    }

    public static void unregister() {
        OcAgentTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

