/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.instana;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.instana.InstanaExporterConfiguration;
import io.opencensus.exporter.trace.instana.InstanaExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class InstanaTraceExporter {
    private static final String REGISTER_NAME = InstanaTraceExporter.class.getName();
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private InstanaTraceExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(InstanaExporterConfiguration configuration) throws MalformedURLException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Instana exporter is already registered.");
            InstanaExporterHandler newHandler = new InstanaExporterHandler(new URL(configuration.getAgentEndpoint()), configuration.getDeadline());
            handler = newHandler;
            InstanaTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), (SpanExporter.Handler)newHandler);
        }
    }

    @Deprecated
    public static void createAndRegister(String agentEndpoint) throws MalformedURLException {
        InstanaTraceExporter.createAndRegister(InstanaExporterConfiguration.builder().setAgentEndpoint(agentEndpoint).build());
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Instana exporter is not registered.");
            InstanaTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

