/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.datadog;

import com.google.common.base.Preconditions;
import io.opencensus.exporter.trace.datadog.DatadogExporterHandler;
import io.opencensus.exporter.trace.datadog.DatadogTraceConfiguration;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import java.net.MalformedURLException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class DatadogTraceExporter {
    private static final Object monitor = new Object();
    private static final String REGISTER_NAME = DatadogTraceExporter.class.getName();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private DatadogTraceExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(DatadogTraceConfiguration configuration) throws MalformedURLException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Datadog exporter is already registered.");
            String agentEndpoint = configuration.getAgentEndpoint();
            String service = configuration.getService();
            String type = configuration.getType();
            DatadogExporterHandler exporterHandler = new DatadogExporterHandler(agentEndpoint, service, type);
            handler = exporterHandler;
            Tracing.getExportComponent().getSpanExporter().registerHandler(REGISTER_NAME, (SpanExporter.Handler)exporterHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Datadog exporter is not registered.");
            Tracing.getExportComponent().getSpanExporter().unregisterHandler(REGISTER_NAME);
            handler = null;
        }
    }
}

