/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.zpages;

import com.google.common.annotations.VisibleForTesting;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.opencensus.common.Scope;
import io.opencensus.contrib.zpages.ZPageHandler;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class ZPageHttpHandler
implements HttpHandler {
    private static final Tracer tracer = Tracing.getTracer();
    private static final String HTTP_SERVER = "HttpServer";
    private final ZPageHandler zpageHandler;
    private final String httpServerSpanName;

    ZPageHttpHandler(ZPageHandler zpageHandler) {
        this.zpageHandler = zpageHandler;
        this.httpServerSpanName = HTTP_SERVER + zpageHandler.getUrlPath();
        Tracing.getExportComponent().getSampledSpanStore().registerSpanNamesForCollection(Arrays.asList(this.httpServerSpanName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(HttpExchange httpExchange) throws IOException {
        try (Scope ss = tracer.spanBuilderWithExplicitParent(this.httpServerSpanName, null).setRecordEvents(true).startScopedSpan();){
            tracer.getCurrentSpan().putAttribute("/http/method ", AttributeValue.stringAttributeValue((String)httpExchange.getRequestMethod()));
            httpExchange.sendResponseHeaders(200, 0L);
            this.zpageHandler.emitHtml(ZPageHttpHandler.uriQueryToMap(httpExchange.getRequestURI()), httpExchange.getResponseBody());
        }
        finally {
            httpExchange.close();
        }
    }

    @VisibleForTesting
    static Map<String, String> uriQueryToMap(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
                continue;
            }
            result.put(pair[0], "");
        }
        return result;
    }
}

