/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.zpages;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.opencensus.common.Duration;
import io.opencensus.contrib.grpc.metrics.RpcViewConstants;
import io.opencensus.contrib.zpages.ZPageHandler;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagValue;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

final class RpczZPageHandler
extends ZPageHandler {
    private final ViewManager viewManager;
    private static final String RPCZ_URL = "/rpcz";
    private static final String SENT = "Sent";
    private static final String RECEIVED = "Received";
    private static final String TITLE_COLOR = "\"#eeeeff\"";
    private static final String TABLE_HEADER_COLOR = "\"#fff5ee\"";
    private static final String TABLE_ROW_COLOR = "\"#eee5de\"";
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final double SECONDS_PER_HOUR = 3600.0;
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static final double BYTES_PER_KB = 1024.0;
    private static final ImmutableList<String> RPC_STATS_TYPES = ImmutableList.of((Object)"Count", (Object)"Avg latency (ms)", (Object)"Rate (rpc/s)", (Object)"Input (kb/s)", (Object)"Output (kb/s)", (Object)"Errors");
    private static final ImmutableList<View> CLIENT_RPC_CUMULATIVE_VIEWS = ImmutableList.of((Object)RpcViewConstants.RPC_CLIENT_ERROR_COUNT_VIEW, (Object)RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW, (Object)RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_VIEW, (Object)RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_VIEW, (Object)RpcViewConstants.RPC_CLIENT_STARTED_COUNT_CUMULATIVE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_VIEW, (Object)RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_VIEW, (Object)RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_VIEW, (Object)RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_VIEW, (Object)RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_CUMULATIVE_VIEW);
    private static final ImmutableList<View> SERVER_RPC_CUMULATIVE_VIEWS = ImmutableList.of((Object)RpcViewConstants.RPC_SERVER_ERROR_COUNT_VIEW, (Object)RpcViewConstants.RPC_SERVER_SERVER_LATENCY_VIEW, (Object)RpcViewConstants.RPC_SERVER_REQUEST_BYTES_VIEW, (Object)RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_VIEW, (Object)RpcViewConstants.RPC_SERVER_STARTED_COUNT_CUMULATIVE_VIEW, (Object)RpcViewConstants.RPC_SERVER_REQUEST_COUNT_VIEW, (Object)RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_VIEW, (Object)RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_VIEW, (Object)RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_VIEW, (Object)RpcViewConstants.RPC_SERVER_FINISHED_COUNT_CUMULATIVE_VIEW);
    private static final ImmutableList<View> CLIENT_RPC_MINUTE_VIEWS = ImmutableList.of((Object)RpcViewConstants.RPC_CLIENT_ERROR_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_STARTED_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_MINUTE_VIEW);
    private static final ImmutableList<View> SERVER_RPC_MINUTE_VIEWS = ImmutableList.of((Object)RpcViewConstants.RPC_SERVER_ERROR_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_SERVER_LATENCY_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_REQUEST_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_STARTED_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_REQUEST_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW, (Object)RpcViewConstants.RPC_SERVER_FINISHED_COUNT_MINUTE_VIEW);
    private static final ImmutableList<View> CLIENT_RPC_HOUR_VIEWS = ImmutableList.of((Object)RpcViewConstants.RPC_CLIENT_ERROR_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_STARTED_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_HOUR_VIEW);
    private static final ImmutableList<View> SERVER_RPC_HOUR_VIEWS = ImmutableList.of((Object)RpcViewConstants.RPC_SERVER_ERROR_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_SERVER_LATENCY_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_REQUEST_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_STARTED_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_REQUEST_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW, (Object)RpcViewConstants.RPC_SERVER_FINISHED_COUNT_HOUR_VIEW);

    @Override
    public String getUrlPath() {
        return RPCZ_URL;
    }

    @Override
    public void emitHtml(Map<String, String> queryMap, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8)));
        out.write("<!DOCTYPE html>\n");
        out.write("<html lang=\"en\"><head>\n");
        out.write("<meta charset=\"utf-8\">\n");
        out.write("<title>RpcZ</title>\n");
        out.write("<link rel=\"shortcut icon\" href=\"//www.opencensus.io/favicon.ico\"/>\n");
        out.write("</head>\n");
        out.write("<body>\n");
        try {
            this.emitHtmlBody(out);
        }
        catch (Throwable t) {
            out.write("Errors while generate the HTML page " + t);
        }
        out.write("</body>\n");
        out.write("</html>\n");
        out.close();
    }

    private void emitHtmlBody(PrintWriter out) {
        Formatter formatter = new Formatter(out, Locale.US);
        out.write("<h1>RPC Stats</h1>");
        out.write("<p></p>");
        this.emitSummaryTable(out, formatter, false);
        this.emitSummaryTable(out, formatter, true);
    }

    private void emitSummaryTable(PrintWriter out, Formatter formatter, boolean isReceived) {
        formatter.format("<p><table bgcolor=%s width=100%%><tr align=center><td><font size=+2>%s</font></td></tr></table></p>", TITLE_COLOR, isReceived ? RECEIVED : SENT);
        formatter.format("<table bgcolor=%s frame=box cellspacing=0 cellpadding=2>", TABLE_HEADER_COLOR);
        RpczZPageHandler.emitSummaryTableHeader(out, formatter);
        Map<String, StatsSnapshot> snapshots = this.getStatsSnapshots(isReceived);
        for (Map.Entry<String, StatsSnapshot> entry : snapshots.entrySet()) {
            RpczZPageHandler.emitSummaryTableRows(out, formatter, entry.getValue(), entry.getKey());
        }
        out.write("</table>");
    }

    private static void emitSummaryTableHeader(PrintWriter out, Formatter formatter) {
        formatter.format("<tr bgcolor=%s>", TABLE_ROW_COLOR);
        out.write("<th></th><td></td>");
        for (String rpcStatsType : RPC_STATS_TYPES) {
            formatter.format("<th class=\"l1\" colspan=3>%s</th><td></td>", rpcStatsType);
        }
        out.write("</tr>");
        formatter.format("<tr bgcolor=%s>", TABLE_ROW_COLOR);
        out.write("<th align=left>Method</th><td>&nbsp;&nbsp;&nbsp;&nbsp;</td>");
        for (int i = 0; i < RPC_STATS_TYPES.size(); ++i) {
            out.write("<th align=right>Min.</th><th align=right>Hr.</th><th align=right>Tot.</th>");
            if (i == RPC_STATS_TYPES.size() - 1) continue;
            out.write("<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>");
        }
        out.write("</tr>");
        out.write("<tr><td colspan=33><font size=-2>&nbsp;</font></td></tr>");
    }

    private static void emitSummaryTableRows(PrintWriter out, Formatter formatter, StatsSnapshot snapshot, String method) {
        out.write("<tr>");
        formatter.format("<td><b>%s</b></td>", method);
        out.write("<td></td>");
        formatter.format("<td align=\"right\">%d</td>", snapshot.countLastMinute);
        formatter.format("<td align=\"right\">%d</td>", snapshot.countLastHour);
        formatter.format("<td align=\"right\">%d</td><td></td>", snapshot.countTotal);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.avgLatencyLastMinute);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.avgLatencyLastHour);
        formatter.format("<td align=\"right\">%.3f</td><td></td>", snapshot.avgLatencyTotal);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.rpcRateLastMinute);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.rpcRateLastHour);
        formatter.format("<td align=\"right\">%.3f</td><td></td>", snapshot.rpcRateTotal);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.inputRateLastMinute);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.inputRateLastHour);
        formatter.format("<td align=\"right\">%.3f</td><td></td>", snapshot.inputRateTotal);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.outputRateLastMinute);
        formatter.format("<td align=\"right\">%.3f</td>", snapshot.outputRateLastHour);
        formatter.format("<td align=\"right\">%.3f</td><td></td>", snapshot.outputRateTotal);
        formatter.format("<td align=\"right\">%d</td>", snapshot.errorsLastMinute);
        formatter.format("<td align=\"right\">%d</td>", snapshot.errorsLastHour);
        formatter.format("<td align=\"right\">%d</td><td></td>", snapshot.errorsTotal);
        out.write("</tr>");
    }

    private Map<String, StatsSnapshot> getStatsSnapshots(boolean isReceived) {
        TreeMap map = Maps.newTreeMap();
        if (isReceived) {
            this.getStatsSnapshots(map, (List<View>)SERVER_RPC_CUMULATIVE_VIEWS);
            this.getStatsSnapshots(map, (List<View>)SERVER_RPC_MINUTE_VIEWS);
            this.getStatsSnapshots(map, (List<View>)SERVER_RPC_HOUR_VIEWS);
        } else {
            this.getStatsSnapshots(map, (List<View>)CLIENT_RPC_CUMULATIVE_VIEWS);
            this.getStatsSnapshots(map, (List<View>)CLIENT_RPC_MINUTE_VIEWS);
            this.getStatsSnapshots(map, (List<View>)CLIENT_RPC_HOUR_VIEWS);
        }
        return map;
    }

    private void getStatsSnapshots(Map<String, StatsSnapshot> map, List<View> views) {
        for (View view : views) {
            ViewData viewData = this.viewManager.getView(view.getName());
            if (viewData == null) continue;
            for (Map.Entry entry : viewData.getAggregationMap().entrySet()) {
                List tagValues = (List)entry.getKey();
                TagValue tagValue = tagValues.size() == 1 ? (TagValue)tagValues.get(0) : (TagValue)tagValues.get(1);
                String method = tagValue == null ? "" : tagValue.asString();
                StatsSnapshot snapshot = map.get(method);
                if (snapshot == null) {
                    snapshot = new StatsSnapshot();
                    map.put(method, snapshot);
                }
                RpczZPageHandler.getStats(snapshot, (AggregationData)entry.getValue(), view, viewData.getWindowData());
            }
        }
    }

    private static void getStats(StatsSnapshot snapshot, AggregationData data, View view, ViewData.AggregationWindowData windowData) {
        if (view == RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW || view == RpcViewConstants.RPC_SERVER_SERVER_LATENCY_VIEW) {
            snapshot.avgLatencyTotal = ((AggregationData.DistributionData)data).getMean();
        } else if (view == RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_MINUTE_VIEW || view == RpcViewConstants.RPC_SERVER_SERVER_LATENCY_MINUTE_VIEW) {
            snapshot.avgLatencyLastMinute = ((AggregationData.MeanData)data).getMean();
        } else if (view == RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_HOUR_VIEW || view == RpcViewConstants.RPC_SERVER_SERVER_LATENCY_HOUR_VIEW) {
            snapshot.avgLatencyLastHour = ((AggregationData.MeanData)data).getMean();
        } else if (view == RpcViewConstants.RPC_CLIENT_ERROR_COUNT_VIEW || view == RpcViewConstants.RPC_SERVER_ERROR_COUNT_VIEW) {
            snapshot.errorsTotal = ((AggregationData.MeanData)data).getCount();
        } else if (view == RpcViewConstants.RPC_CLIENT_ERROR_COUNT_MINUTE_VIEW || view == RpcViewConstants.RPC_SERVER_ERROR_COUNT_MINUTE_VIEW) {
            snapshot.errorsLastMinute = ((AggregationData.MeanData)data).getCount();
        } else if (view == RpcViewConstants.RPC_CLIENT_ERROR_COUNT_HOUR_VIEW || view == RpcViewConstants.RPC_SERVER_ERROR_COUNT_HOUR_VIEW) {
            snapshot.errorsLastHour = ((AggregationData.MeanData)data).getCount();
        } else if (view == RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_VIEW || view == RpcViewConstants.RPC_SERVER_REQUEST_BYTES_VIEW) {
            AggregationData.DistributionData distributionData = (AggregationData.DistributionData)data;
            snapshot.inputRateTotal = (double)distributionData.getCount() * distributionData.getMean() / 1024.0 / RpczZPageHandler.getDurationInSecs((ViewData.AggregationWindowData.CumulativeData)windowData);
        } else if (view == RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_MINUTE_VIEW || view == RpcViewConstants.RPC_SERVER_REQUEST_BYTES_MINUTE_VIEW) {
            AggregationData.MeanData meanData = (AggregationData.MeanData)data;
            snapshot.inputRateLastMinute = meanData.getMean() * (double)meanData.getCount() / 1024.0 / 60.0;
        } else if (view == RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_HOUR_VIEW || view == RpcViewConstants.RPC_SERVER_REQUEST_BYTES_HOUR_VIEW) {
            AggregationData.MeanData meanData = (AggregationData.MeanData)data;
            snapshot.inputRateLastHour = meanData.getMean() * (double)meanData.getCount() / 1024.0 / 3600.0;
        } else if (view == RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_VIEW || view == RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_VIEW) {
            AggregationData.DistributionData distributionData = (AggregationData.DistributionData)data;
            snapshot.outputRateTotal = (double)distributionData.getCount() * distributionData.getMean() / 1024.0 / RpczZPageHandler.getDurationInSecs((ViewData.AggregationWindowData.CumulativeData)windowData);
        } else if (view == RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_MINUTE_VIEW || view == RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_MINUTE_VIEW) {
            AggregationData.MeanData meanData = (AggregationData.MeanData)data;
            snapshot.outputRateLastMinute = meanData.getMean() * (double)meanData.getCount() / 1024.0 / 60.0;
        } else if (view == RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_HOUR_VIEW || view == RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_HOUR_VIEW) {
            AggregationData.MeanData meanData = (AggregationData.MeanData)data;
            snapshot.outputRateLastHour = meanData.getMean() * (double)meanData.getCount() / 1024.0 / 3600.0;
        } else if (view == RpcViewConstants.RPC_CLIENT_STARTED_COUNT_MINUTE_VIEW || view == RpcViewConstants.RPC_SERVER_STARTED_COUNT_MINUTE_VIEW) {
            snapshot.countLastMinute = ((AggregationData.CountData)data).getCount();
            snapshot.rpcRateLastMinute = (double)snapshot.countLastMinute / 60.0;
        } else if (view == RpcViewConstants.RPC_CLIENT_STARTED_COUNT_HOUR_VIEW || view == RpcViewConstants.RPC_SERVER_STARTED_COUNT_HOUR_VIEW) {
            snapshot.countLastHour = ((AggregationData.CountData)data).getCount();
            snapshot.rpcRateLastHour = (double)snapshot.countLastHour / 3600.0;
        } else if (view == RpcViewConstants.RPC_CLIENT_STARTED_COUNT_CUMULATIVE_VIEW || view == RpcViewConstants.RPC_SERVER_STARTED_COUNT_CUMULATIVE_VIEW) {
            snapshot.countTotal = ((AggregationData.CountData)data).getCount();
            snapshot.rpcRateTotal = (double)snapshot.countTotal / RpczZPageHandler.getDurationInSecs((ViewData.AggregationWindowData.CumulativeData)windowData);
        }
    }

    private static double getDurationInSecs(ViewData.AggregationWindowData.CumulativeData cumulativeData) {
        return RpczZPageHandler.toDoubleSeconds(cumulativeData.getEnd().subtractTimestamp(cumulativeData.getStart()));
    }

    private static double toDoubleSeconds(Duration duration) {
        return (double)duration.getNanos() / 1.0E9 + (double)duration.getSeconds();
    }

    static RpczZPageHandler create(ViewManager viewManager) {
        return new RpczZPageHandler(viewManager);
    }

    private RpczZPageHandler(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    private static class StatsSnapshot {
        long countLastMinute;
        long countLastHour;
        long countTotal;
        double rpcRateLastMinute;
        double rpcRateLastHour;
        double rpcRateTotal;
        double avgLatencyLastMinute;
        double avgLatencyLastHour;
        double avgLatencyTotal;
        double inputRateLastMinute;
        double inputRateLastHour;
        double inputRateTotal;
        double outputRateLastMinute;
        double outputRateLastHour;
        double outputRateTotal;
        long errorsLastMinute;
        long errorsLastHour;
        long errorsTotal;

        private StatsSnapshot() {
        }
    }
}

