/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.zpages;

import com.google.common.base.Preconditions;
import com.sun.net.httpserver.HttpServer;
import io.opencensus.contrib.zpages.TraceConfigzZPageHandler;
import io.opencensus.contrib.zpages.TracezZPageHandler;
import io.opencensus.contrib.zpages.ZPageHandler;
import io.opencensus.contrib.zpages.ZPageHttpHandler;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ZPageHandlers {
    private static final int BACKLOG = 5;
    private static final int STOP_DELAY = 1;
    private static final Logger logger = Logger.getLogger(ZPageHandler.class.getName());
    private static final ZPageHandler tracezZPageHandler = TracezZPageHandler.create(Tracing.getExportComponent().getRunningSpanStore(), Tracing.getExportComponent().getSampledSpanStore());
    private static final ZPageHandler traceConfigzZPageHandler = TraceConfigzZPageHandler.create(Tracing.getTraceConfig());
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static HttpServer server;

    public static ZPageHandler getTracezZPageHandler() {
        return tracezZPageHandler;
    }

    public static ZPageHandler getTraceConfigzZPageHandler() {
        return traceConfigzZPageHandler;
    }

    public static void registerAllToHttpServer(HttpServer server) {
        server.createContext(tracezZPageHandler.getUrlPath(), new ZPageHttpHandler(tracezZPageHandler));
        server.createContext(traceConfigzZPageHandler.getUrlPath(), new ZPageHttpHandler(traceConfigzZPageHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startHttpServerAndRegisterAll(int port) throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((server == null ? 1 : 0) != 0, (Object)"The HttpServer is already started.");
            server = HttpServer.create(new InetSocketAddress(port), 5);
            ZPageHandlers.registerAllToHttpServer(server);
            server.start();
            logger.fine("HttpServer started on address " + server.getAddress().toString());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.fine("*** Shutting down gRPC server (JVM shutting down)");
                ZPageHandlers.stop();
                logger.fine("*** Server shut down");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stop() {
        Object object = monitor;
        synchronized (object) {
            if (server == null) {
                throw new IllegalStateException("The HttpServer is already stopped.");
            }
            server.stop(1);
            server = null;
        }
    }

    private ZPageHandlers() {
    }
}

