/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.logcorrelation.stackdriver;

import com.google.cloud.ServiceOptions;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.logging.LogManager;
import javax.annotation.Nullable;

public final class OpenCensusTraceLoggingEnhancer
implements LoggingEnhancer {
    private static final String SAMPLED_LABEL_KEY = "openCensusTraceSampled";
    private static final SpanSelection DEFAULT_SPAN_SELECTION = SpanSelection.ALL_SPANS;
    public static final String PROJECT_ID_PROPERTY_NAME = "io.opencensus.contrib.logcorrelation.stackdriver.OpenCensusTraceLoggingEnhancer.projectId";
    public static final String SPAN_SELECTION_PROPERTY_NAME = "io.opencensus.contrib.logcorrelation.stackdriver.OpenCensusTraceLoggingEnhancer.spanSelection";
    private static final Tracer tracer = Tracing.getTracer();
    private final String projectId;
    private final SpanSelection spanSelection;
    private final String tracePrefix;

    public OpenCensusTraceLoggingEnhancer() {
        this(OpenCensusTraceLoggingEnhancer.lookUpProjectId(), OpenCensusTraceLoggingEnhancer.lookUpSpanSelectionProperty());
    }

    public OpenCensusTraceLoggingEnhancer(@Nullable String projectId, SpanSelection spanSelection) {
        this.projectId = projectId == null ? "" : projectId;
        this.spanSelection = spanSelection;
        this.tracePrefix = "projects/" + this.projectId + "/traces/";
    }

    private static String lookUpProjectId() {
        String projectIdProperty = OpenCensusTraceLoggingEnhancer.lookUpProperty(PROJECT_ID_PROPERTY_NAME);
        return projectIdProperty == null || projectIdProperty.isEmpty() ? ServiceOptions.getDefaultProjectId() : projectIdProperty;
    }

    private static SpanSelection lookUpSpanSelectionProperty() {
        String spanSelectionProperty = OpenCensusTraceLoggingEnhancer.lookUpProperty(SPAN_SELECTION_PROPERTY_NAME);
        return spanSelectionProperty == null || spanSelectionProperty.isEmpty() ? DEFAULT_SPAN_SELECTION : OpenCensusTraceLoggingEnhancer.parseSpanSelection(spanSelectionProperty);
    }

    private static SpanSelection parseSpanSelection(String spanSelection) {
        try {
            return SpanSelection.valueOf(spanSelection);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_SPAN_SELECTION;
        }
    }

    private static String lookUpProperty(String name) {
        String property = LogManager.getLogManager().getProperty(name);
        return property == null || property.isEmpty() ? System.getProperty(name) : property;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public SpanSelection getSpanSelection() {
        return this.spanSelection;
    }

    public void enhanceLogEntry(LogEntry.Builder builder) {
        switch (this.spanSelection) {
            case NO_SPANS: {
                return;
            }
            case SAMPLED_SPANS: {
                SpanContext span = tracer.getCurrentSpan().getContext();
                if (span.getTraceOptions().isSampled()) {
                    OpenCensusTraceLoggingEnhancer.addTracingData(this.tracePrefix, span, builder);
                }
                return;
            }
            case ALL_SPANS: {
                OpenCensusTraceLoggingEnhancer.addTracingData(this.tracePrefix, tracer.getCurrentSpan().getContext(), builder);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown spanSelection: " + (Object)((Object)this.spanSelection)));
    }

    private static void addTracingData(String tracePrefix, SpanContext span, LogEntry.Builder builder) {
        builder.setTrace(OpenCensusTraceLoggingEnhancer.formatTraceId(tracePrefix, span.getTraceId()));
        builder.setSpanId(span.getSpanId().toLowerBase16());
        builder.addLabel(SAMPLED_LABEL_KEY, Boolean.toString(span.getTraceOptions().isSampled()));
    }

    private static String formatTraceId(String tracePrefix, TraceId traceId) {
        return tracePrefix + traceId.toLowerBase16();
    }

    public static enum SpanSelection {
        NO_SPANS,
        SAMPLED_SPANS,
        ALL_SPANS;

    }
}

