/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.instrumentation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opencensus.contrib.agent.bootstrap.ContextTrampoline;
import io.opencensus.contrib.agent.deps.bytebuddy.agent.builder.AgentBuilder;
import io.opencensus.contrib.agent.deps.bytebuddy.asm.Advice;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.DynamicType;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatcher;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.JavaModule;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.instrumentation.Instrumenter;
import java.util.concurrent.Executor;

public final class ExecutorInstrumentation
implements Instrumenter {
    @Override
    public AgentBuilder instrument(AgentBuilder agentBuilder) {
        Preconditions.checkNotNull(agentBuilder, "agentBuilder");
        return agentBuilder.type(ExecutorInstrumentation.createMatcher()).transform(new Transformer());
    }

    private static ElementMatcher.Junction<TypeDescription> createMatcher() {
        return ElementMatchers.isSubTypeOf(Executor.class).and(ElementMatchers.not(ElementMatchers.isAbstract())).and(ElementMatchers.not(ElementMatchers.nameStartsWith("io.grpc.Context$").and(ElementMatchers.nameEndsWith("CurrentContextExecutor").or(ElementMatchers.nameEndsWith("FixedContextExecutor")))));
    }

    private static class Execute {
        private Execute() {
        }

        @Advice.OnMethodEnter
        @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE", "UPM_UNCALLED_PRIVATE_METHOD"})
        private static void enter(@Advice.Argument(value=0, readOnly=false) Runnable runnable) {
            runnable = ContextTrampoline.wrapInCurrentContext((Runnable)runnable);
        }
    }

    private static class Transformer
    implements AgentBuilder.Transformer {
        private Transformer() {
        }

        @Override
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            return builder.visit(Advice.to(Execute.class).on(ElementMatchers.named("execute")));
        }
    }
}

