/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.asm;

import io.opencensus.contrib.agent.deps.bytebuddy.asm.AsmVisitorWrapper;
import io.opencensus.contrib.agent.deps.bytebuddy.description.ByteCodeElement;
import io.opencensus.contrib.agent.deps.bytebuddy.description.field.FieldDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.field.FieldList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDefinition;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeList;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodGraph;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.Duplication;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.Removal;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackSize;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant.DefaultValue;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.member.FieldAccess;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.member.MethodInvocation;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatcher;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.bytebuddy.pool.TypePool;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.CompoundList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MemberSubstitution
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
    private final MethodGraph.Compiler methodGraphCompiler;
    private final boolean strict;
    private final Substitution substitution;

    protected MemberSubstitution(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution) {
        this.methodGraphCompiler = methodGraphCompiler;
        this.strict = strict;
        this.substitution = substitution;
    }

    public static MemberSubstitution strict() {
        return new MemberSubstitution(MethodGraph.Compiler.DEFAULT, true, Substitution.NoOp.INSTANCE);
    }

    public static MemberSubstitution relaxed() {
        return new MemberSubstitution(MethodGraph.Compiler.DEFAULT, false, Substitution.NoOp.INSTANCE);
    }

    public WithoutSpecification element(ElementMatcher<? super ByteCodeElement> matcher) {
        return new WithoutSpecification.ForMatchedByteCodeElement(this.methodGraphCompiler, this.strict, this.substitution, matcher);
    }

    public WithoutSpecification.ForMatchedField field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return new WithoutSpecification.ForMatchedField(this.methodGraphCompiler, this.strict, this.substitution, matcher);
    }

    public WithoutSpecification.ForMatchedMethod method(ElementMatcher<? super MethodDescription> matcher) {
        return new WithoutSpecification.ForMatchedMethod(this.methodGraphCompiler, this.strict, this.substitution, matcher);
    }

    public WithoutSpecification constructor(ElementMatcher<? super MethodDescription> matcher) {
        return this.invokable(ElementMatchers.isConstructor().and(matcher));
    }

    public WithoutSpecification invokable(ElementMatcher<? super MethodDescription> matcher) {
        return new WithoutSpecification.ForMatchedMethod(this.methodGraphCompiler, this.strict, this.substitution, matcher);
    }

    public MemberSubstitution with(MethodGraph.Compiler methodGraphCompiler) {
        return new MemberSubstitution(methodGraphCompiler, this.strict, this.substitution);
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().method(matcher, this);
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return new SubstitutingMethodVisitor(methodVisitor, this.methodGraphCompiler, this.strict, this.substitution, instrumentedType, implementationContext, typePool);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberSubstitution)) {
            return false;
        }
        MemberSubstitution other = (MemberSubstitution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodGraph.Compiler this$methodGraphCompiler = this.methodGraphCompiler;
        MethodGraph.Compiler other$methodGraphCompiler = other.methodGraphCompiler;
        if (this$methodGraphCompiler == null ? other$methodGraphCompiler != null : !this$methodGraphCompiler.equals(other$methodGraphCompiler)) {
            return false;
        }
        if (this.strict != other.strict) {
            return false;
        }
        Substitution this$substitution = this.substitution;
        Substitution other$substitution = other.substitution;
        return !(this$substitution == null ? other$substitution != null : !this$substitution.equals(other$substitution));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MemberSubstitution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodGraph.Compiler $methodGraphCompiler = this.methodGraphCompiler;
        result = result * 59 + ($methodGraphCompiler == null ? 43 : $methodGraphCompiler.hashCode());
        result = result * 59 + (this.strict ? 79 : 97);
        Substitution $substitution = this.substitution;
        result = result * 59 + ($substitution == null ? 43 : $substitution.hashCode());
        return result;
    }

    protected static class SubstitutingMethodVisitor
    extends MethodVisitor {
        private final MethodGraph.Compiler methodGraphCompiler;
        private final boolean strict;
        private final Substitution substitution;
        private final TypeDescription instrumentedType;
        private final Implementation.Context implementationContext;
        private final TypePool typePool;
        private int stackSizeBuffer;

        protected SubstitutingMethodVisitor(MethodVisitor methodVisitor, MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, TypeDescription instrumentedType, Implementation.Context implementationContext, TypePool typePool) {
            super(327680, methodVisitor);
            this.methodGraphCompiler = methodGraphCompiler;
            this.strict = strict;
            this.substitution = substitution;
            this.instrumentedType = instrumentedType;
            this.implementationContext = implementationContext;
            this.typePool = typePool;
            this.stackSizeBuffer = 0;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String internalName, String descriptor) {
            TypePool.Resolution resolution = this.typePool.describe(owner.replace('/', '.'));
            if (resolution.isResolved()) {
                FieldList candidates = (FieldList)resolution.resolve().getDeclaredFields().filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor)));
                if (!candidates.isEmpty()) {
                    Substitution.Resolver resolver = this.substitution.resolve((FieldDescription.InDefinedShape)candidates.getOnly(), opcode == 181 || opcode == 179);
                    if (resolver.isResolved()) {
                        TypeDescription.Generic result;
                        AbstractList arguments;
                        switch (opcode) {
                            case 181: {
                                arguments = new TypeList.Generic.Explicit(((FieldDescription.InDefinedShape)candidates.getOnly()).getDeclaringType(), ((FieldDescription.InDefinedShape)candidates.getOnly()).getType());
                                result = TypeDescription.Generic.VOID;
                                break;
                            }
                            case 179: {
                                arguments = new TypeList.Generic.Explicit(((FieldDescription.InDefinedShape)candidates.getOnly()).getType());
                                result = TypeDescription.Generic.VOID;
                                break;
                            }
                            case 180: {
                                arguments = new TypeList.Generic.Explicit(((FieldDescription.InDefinedShape)candidates.getOnly()).getDeclaringType());
                                result = ((FieldDescription.InDefinedShape)candidates.getOnly()).getType();
                                break;
                            }
                            case 178: {
                                arguments = new TypeList.Generic.Empty();
                                result = ((FieldDescription.InDefinedShape)candidates.getOnly()).getType();
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        resolver.apply(this.instrumentedType, (ByteCodeElement)candidates.getOnly(), (TypeList.Generic)((Object)arguments), result).apply(this.mv, this.implementationContext);
                        return;
                    }
                } else if (this.strict) {
                    throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + "." + internalName + descriptor + " using " + this.typePool);
                }
            } else if (this.strict) {
                throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + " using " + this.typePool);
            }
            super.visitFieldInsn(opcode, owner, internalName, descriptor);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String internalName, String descriptor, boolean isInterface) {
            TypePool.Resolution resolution = this.typePool.describe(owner.replace('/', '.'));
            if (resolution.isResolved()) {
                MethodList candidates = opcode == 183 && internalName.equals("<init>") ? (MethodList)resolution.resolve().getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.hasDescriptor(descriptor))) : (opcode == 184 || opcode == 183 ? (MethodList)resolution.resolve().getDeclaredMethods().filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor))) : (MethodList)this.methodGraphCompiler.compile(resolution.resolve()).listNodes().asMethodList().filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor))));
                if (!candidates.isEmpty()) {
                    Substitution.Resolver resolver = this.substitution.resolve((MethodDescription)candidates.getOnly(), Substitution.InvocationType.of(opcode, (MethodDescription)candidates.getOnly()));
                    if (resolver.isResolved()) {
                        resolver.apply(this.instrumentedType, (ByteCodeElement)candidates.getOnly(), ((MethodDescription)candidates.getOnly()).isStatic() || ((MethodDescription)candidates.getOnly()).isConstructor() ? ((MethodDescription)candidates.getOnly()).getParameters().asTypeList() : new TypeList.Generic.Explicit(CompoundList.of(((MethodDescription)candidates.getOnly()).getDeclaringType(), ((MethodDescription)candidates.getOnly()).getParameters().asTypeList())), ((MethodDescription)candidates.getOnly()).isConstructor() ? ((MethodDescription)candidates.getOnly()).getDeclaringType().asGenericType() : ((MethodDescription)candidates.getOnly()).getReturnType()).apply(this.mv, this.implementationContext);
                        if (((MethodDescription)candidates.getOnly()).isConstructor()) {
                            this.stackSizeBuffer = new StackManipulation.Compound(Duplication.SINGLE.flipOver(TypeDescription.OBJECT), Removal.SINGLE, Removal.SINGLE, Duplication.SINGLE.flipOver(TypeDescription.OBJECT), Removal.SINGLE, Removal.SINGLE).apply(this.mv, this.implementationContext).getMaximalSize() + StackSize.SINGLE.getSize();
                        }
                        return;
                    }
                } else if (this.strict) {
                    throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + "." + internalName + descriptor + " using " + this.typePool);
                }
            } else if (this.strict) {
                throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + " using " + this.typePool);
            }
            super.visitMethodInsn(opcode, owner, internalName, descriptor, isInterface);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack + this.stackSizeBuffer, maxLocals);
        }
    }

    protected static interface Substitution {
        public Resolver resolve(FieldDescription.InDefinedShape var1, boolean var2);

        public Resolver resolve(MethodDescription var1, InvocationType var2);

        public static class Compound
        implements Substitution {
            private final List<Substitution> substitutions;

            protected Compound(Substitution ... substitution) {
                this(Arrays.asList(substitution));
            }

            protected Compound(List<? extends Substitution> substitutions) {
                this.substitutions = new ArrayList<Substitution>(substitutions.size());
                for (Substitution substitution : substitutions) {
                    if (substitution instanceof Compound) {
                        this.substitutions.addAll(((Compound)substitution).substitutions);
                        continue;
                    }
                    if (substitution instanceof NoOp) continue;
                    this.substitutions.add(substitution);
                }
            }

            @Override
            public Resolver resolve(FieldDescription.InDefinedShape fieldDescription, boolean writeAccess) {
                for (Substitution substitution : this.substitutions) {
                    Resolver resolver = substitution.resolve(fieldDescription, writeAccess);
                    if (!resolver.isResolved()) continue;
                    return resolver;
                }
                return Resolver.Unresolved.INSTANCE;
            }

            @Override
            public Resolver resolve(MethodDescription methodDescription, InvocationType invocationType) {
                for (Substitution substitution : this.substitutions) {
                    Resolver resolver = substitution.resolve(methodDescription, invocationType);
                    if (!resolver.isResolved()) continue;
                    return resolver;
                }
                return Resolver.Unresolved.INSTANCE;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Compound)) {
                    return false;
                }
                Compound other = (Compound)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Substitution> this$substitutions = this.substitutions;
                List<Substitution> other$substitutions = other.substitutions;
                return !(this$substitutions == null ? other$substitutions != null : !((Object)this$substitutions).equals(other$substitutions));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Compound;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Substitution> $substitutions = this.substitutions;
                result = result * 59 + ($substitutions == null ? 43 : ((Object)$substitutions).hashCode());
                return result;
            }
        }

        public static class ForElementMatchers
        implements Substitution {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher;
            private final ElementMatcher<? super MethodDescription> methodMatcher;
            private final boolean matchFieldRead;
            private final boolean matchFieldWrite;
            private final boolean includeVirtualCalls;
            private final boolean includeSuperCalls;
            private final Resolver resolver;

            protected static Substitution of(ElementMatcher<? super ByteCodeElement> matcher, Resolver resolver) {
                return new ForElementMatchers(matcher, matcher, true, true, true, true, resolver);
            }

            protected static Substitution ofField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, boolean matchFieldRead, boolean matchFieldWrite, Resolver resolver) {
                return new ForElementMatchers(matcher, ElementMatchers.none(), matchFieldRead, matchFieldWrite, false, false, resolver);
            }

            protected static Substitution ofMethod(ElementMatcher<? super MethodDescription> matcher, boolean includeVirtualCalls, boolean includeSuperCalls, Resolver resolver) {
                return new ForElementMatchers(ElementMatchers.none(), matcher, false, false, includeVirtualCalls, includeSuperCalls, resolver);
            }

            protected ForElementMatchers(ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher<? super MethodDescription> methodMatcher, boolean matchFieldRead, boolean matchFieldWrite, boolean includeVirtualCalls, boolean includeSuperCalls, Resolver resolver) {
                this.fieldMatcher = fieldMatcher;
                this.methodMatcher = methodMatcher;
                this.matchFieldRead = matchFieldRead;
                this.matchFieldWrite = matchFieldWrite;
                this.includeVirtualCalls = includeVirtualCalls;
                this.includeSuperCalls = includeSuperCalls;
                this.resolver = resolver;
            }

            @Override
            public Resolver resolve(FieldDescription.InDefinedShape fieldDescription, boolean writeAccess) {
                return (writeAccess ? this.matchFieldWrite : this.matchFieldRead) && this.fieldMatcher.matches(fieldDescription) ? this.resolver : Resolver.Unresolved.INSTANCE;
            }

            @Override
            public Resolver resolve(MethodDescription methodDescription, InvocationType invocationType) {
                return invocationType.matches(this.includeVirtualCalls, this.includeSuperCalls) && this.methodMatcher.matches(methodDescription) ? this.resolver : Resolver.Unresolved.INSTANCE;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForElementMatchers)) {
                    return false;
                }
                ForElementMatchers other = (ForElementMatchers)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ElementMatcher<? super FieldDescription.InDefinedShape> this$fieldMatcher = this.fieldMatcher;
                ElementMatcher<? super FieldDescription.InDefinedShape> other$fieldMatcher = other.fieldMatcher;
                if (this$fieldMatcher == null ? other$fieldMatcher != null : !this$fieldMatcher.equals(other$fieldMatcher)) {
                    return false;
                }
                ElementMatcher<? super MethodDescription> this$methodMatcher = this.methodMatcher;
                ElementMatcher<? super MethodDescription> other$methodMatcher = other.methodMatcher;
                if (this$methodMatcher == null ? other$methodMatcher != null : !this$methodMatcher.equals(other$methodMatcher)) {
                    return false;
                }
                if (this.matchFieldRead != other.matchFieldRead) {
                    return false;
                }
                if (this.matchFieldWrite != other.matchFieldWrite) {
                    return false;
                }
                if (this.includeVirtualCalls != other.includeVirtualCalls) {
                    return false;
                }
                if (this.includeSuperCalls != other.includeSuperCalls) {
                    return false;
                }
                Resolver this$resolver = this.resolver;
                Resolver other$resolver = other.resolver;
                return !(this$resolver == null ? other$resolver != null : !this$resolver.equals(other$resolver));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForElementMatchers;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ElementMatcher<? super FieldDescription.InDefinedShape> $fieldMatcher = this.fieldMatcher;
                result = result * 59 + ($fieldMatcher == null ? 43 : $fieldMatcher.hashCode());
                ElementMatcher<? super MethodDescription> $methodMatcher = this.methodMatcher;
                result = result * 59 + ($methodMatcher == null ? 43 : $methodMatcher.hashCode());
                result = result * 59 + (this.matchFieldRead ? 79 : 97);
                result = result * 59 + (this.matchFieldWrite ? 79 : 97);
                result = result * 59 + (this.includeVirtualCalls ? 79 : 97);
                result = result * 59 + (this.includeSuperCalls ? 79 : 97);
                Resolver $resolver = this.resolver;
                result = result * 59 + ($resolver == null ? 43 : $resolver.hashCode());
                return result;
            }
        }

        public static enum NoOp implements Substitution
        {
            INSTANCE;


            @Override
            public Resolver resolve(FieldDescription.InDefinedShape fieldDescription, boolean writeAccess) {
                return Resolver.Unresolved.INSTANCE;
            }

            @Override
            public Resolver resolve(MethodDescription methodDescription, InvocationType invocationType) {
                return Resolver.Unresolved.INSTANCE;
            }
        }

        public static enum InvocationType {
            VIRTUAL,
            SUPER,
            OTHER;


            protected static InvocationType of(int opcode, MethodDescription methodDescription) {
                switch (opcode) {
                    case 182: 
                    case 185: {
                        return VIRTUAL;
                    }
                    case 183: {
                        return methodDescription.isVirtual() ? SUPER : OTHER;
                    }
                }
                return OTHER;
            }

            protected boolean matches(boolean includeVirtualCalls, boolean includeSuperCalls) {
                switch (this) {
                    case VIRTUAL: {
                        return includeVirtualCalls;
                    }
                    case SUPER: {
                        return includeSuperCalls;
                    }
                }
                return true;
            }
        }

        public static interface Resolver {
            public boolean isResolved();

            public StackManipulation apply(TypeDescription var1, ByteCodeElement var2, TypeList.Generic var3, TypeDescription.Generic var4);

            public static class MethodInvoking
            implements Resolver {
                private final MethodDescription methodDescription;

                protected MethodInvoking(MethodDescription methodDescription) {
                    this.methodDescription = methodDescription;
                }

                @Override
                public boolean isResolved() {
                    return true;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    TypeList.Generic mapped;
                    if (!this.methodDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException(instrumentedType + " cannot access " + this.methodDescription);
                    }
                    TypeList.Generic generic = mapped = this.methodDescription.isStatic() ? this.methodDescription.getParameters().asTypeList() : new TypeList.Generic.Explicit(CompoundList.of(this.methodDescription.getDeclaringType(), this.methodDescription.getParameters().asTypeList()));
                    if (!this.methodDescription.getReturnType().asErasure().isAssignableTo(result.asErasure())) {
                        throw new IllegalStateException("Cannot assign return value of " + this.methodDescription + " to " + result);
                    }
                    if (mapped.size() != arguments.size()) {
                        throw new IllegalStateException("Cannot invoke " + this.methodDescription + " on " + arguments);
                    }
                    for (int index = 0; index < mapped.size(); ++index) {
                        if (((TypeDescription.Generic)mapped.get(index)).asErasure().isAssignableTo(((TypeDescription.Generic)arguments.get(index)).asErasure())) continue;
                        throw new IllegalStateException("Cannot invoke " + this.methodDescription + " on " + arguments);
                    }
                    return this.methodDescription.isVirtual() ? MethodInvocation.invoke(this.methodDescription).virtual(target.getDeclaringType().asErasure()) : MethodInvocation.invoke(this.methodDescription);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MethodInvoking)) {
                        return false;
                    }
                    MethodInvoking other = (MethodInvoking)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription this$methodDescription = this.methodDescription;
                    MethodDescription other$methodDescription = other.methodDescription;
                    return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof MethodInvoking;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription $methodDescription = this.methodDescription;
                    result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                    return result;
                }
            }

            public static class FieldAccessing
            implements Resolver {
                private final FieldDescription fieldDescription;

                protected FieldAccessing(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public boolean isResolved() {
                    return true;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    if (!this.fieldDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException(instrumentedType + " cannot access " + this.fieldDescription);
                    }
                    if (result.represents(Void.TYPE)) {
                        if (arguments.size() != (this.fieldDescription.isStatic() ? 1 : 2)) {
                            throw new IllegalStateException("Cannot set " + this.fieldDescription + " with " + arguments);
                        }
                        if (!this.fieldDescription.isStatic() && !((TypeDescription.Generic)arguments.get(0)).asErasure().isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                            throw new IllegalStateException("Cannot set " + this.fieldDescription + " on " + arguments.get(0));
                        }
                        if (!((TypeDescription.Generic)arguments.get(this.fieldDescription.isStatic() ? 0 : 1)).asErasure().isAssignableTo(this.fieldDescription.getType().asErasure())) {
                            throw new IllegalStateException("Cannot set " + this.fieldDescription + " to " + arguments.get(this.fieldDescription.isStatic() ? 0 : 1));
                        }
                        return FieldAccess.forField(this.fieldDescription).write();
                    }
                    if (arguments.size() != (this.fieldDescription.isStatic() ? 0 : 1)) {
                        throw new IllegalStateException("Cannot set " + this.fieldDescription + " with " + arguments);
                    }
                    if (!this.fieldDescription.isStatic() && !((TypeDescription.Generic)arguments.get(0)).asErasure().isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                        throw new IllegalStateException("Cannot get " + this.fieldDescription + " on " + arguments.get(0));
                    }
                    if (!this.fieldDescription.getType().asErasure().isAssignableTo(result.asErasure())) {
                        throw new IllegalStateException("Cannot get " + this.fieldDescription + " as " + result);
                    }
                    return FieldAccess.forField(this.fieldDescription).read();
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FieldAccessing)) {
                        return false;
                    }
                    FieldAccessing other = (FieldAccessing)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    FieldDescription this$fieldDescription = this.fieldDescription;
                    FieldDescription other$fieldDescription = other.fieldDescription;
                    return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof FieldAccessing;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    FieldDescription $fieldDescription = this.fieldDescription;
                    result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                    return result;
                }
            }

            public static enum Stubbing implements Resolver
            {
                INSTANCE;


                @Override
                public boolean isResolved() {
                    return true;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(arguments.size());
                    for (int index = arguments.size() - 1; index >= 0; --index) {
                        stackManipulations.add(Removal.of((TypeDefinition)arguments.get(index)));
                    }
                    return new StackManipulation.Compound(CompoundList.of(stackManipulations, DefaultValue.of(result.asErasure())));
                }
            }

            public static enum Unresolved implements Resolver
            {
                INSTANCE;


                @Override
                public boolean isResolved() {
                    return false;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    throw new IllegalStateException("Cannot apply unresolved resolver");
                }
            }
        }
    }

    public static abstract class WithoutSpecification {
        protected final MethodGraph.Compiler methodGraphCompiler;
        protected final boolean strict;
        protected final Substitution substitution;

        protected WithoutSpecification(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution) {
            this.methodGraphCompiler = methodGraphCompiler;
            this.strict = strict;
            this.substitution = substitution;
        }

        public MemberSubstitution stub() {
            return new MemberSubstitution(this.methodGraphCompiler, this.strict, new Substitution.Compound(this.doStub(), this.substitution));
        }

        protected abstract Substitution doStub();

        public MemberSubstitution replaceWith(Field field) {
            return this.replaceWith(new FieldDescription.ForLoadedField(field));
        }

        public MemberSubstitution replaceWith(FieldDescription fieldDescription) {
            return new MemberSubstitution(this.methodGraphCompiler, this.strict, new Substitution.Compound(this.doReplaceWith(fieldDescription), this.substitution));
        }

        protected abstract Substitution doReplaceWith(FieldDescription var1);

        public MemberSubstitution replaceWith(Method method) {
            return this.replaceWith(new MethodDescription.ForLoadedMethod(method));
        }

        public MemberSubstitution replaceWith(MethodDescription methodDescription) {
            if (!methodDescription.isMethod()) {
                throw new IllegalArgumentException("Cannot use " + methodDescription + " as a replacement");
            }
            return new MemberSubstitution(this.methodGraphCompiler, this.strict, new Substitution.Compound(this.doReplaceWith(methodDescription), this.substitution));
        }

        protected abstract Substitution doReplaceWith(MethodDescription var1);

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithoutSpecification)) {
                return false;
            }
            WithoutSpecification other = (WithoutSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MethodGraph.Compiler this$methodGraphCompiler = this.methodGraphCompiler;
            MethodGraph.Compiler other$methodGraphCompiler = other.methodGraphCompiler;
            if (this$methodGraphCompiler == null ? other$methodGraphCompiler != null : !this$methodGraphCompiler.equals(other$methodGraphCompiler)) {
                return false;
            }
            if (this.strict != other.strict) {
                return false;
            }
            Substitution this$substitution = this.substitution;
            Substitution other$substitution = other.substitution;
            return !(this$substitution == null ? other$substitution != null : !this$substitution.equals(other$substitution));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WithoutSpecification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodGraph.Compiler $methodGraphCompiler = this.methodGraphCompiler;
            result = result * 59 + ($methodGraphCompiler == null ? 43 : $methodGraphCompiler.hashCode());
            result = result * 59 + (this.strict ? 79 : 97);
            Substitution $substitution = this.substitution;
            result = result * 59 + ($substitution == null ? 43 : $substitution.hashCode());
            return result;
        }

        public static class ForMatchedMethod
        extends WithoutSpecification {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final boolean includeVirtualCalls;
            private final boolean includeSuperCalls;

            protected ForMatchedMethod(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, ElementMatcher<? super MethodDescription> matcher) {
                this(methodGraphCompiler, strict, substitution, matcher, true, true);
            }

            protected ForMatchedMethod(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, ElementMatcher<? super MethodDescription> matcher, boolean includeVirtualCalls, boolean includeSuperCalls) {
                super(methodGraphCompiler, strict, substitution);
                this.matcher = matcher;
                this.includeVirtualCalls = includeVirtualCalls;
                this.includeSuperCalls = includeSuperCalls;
            }

            public WithoutSpecification onVirtualCall() {
                return new ForMatchedMethod(this.methodGraphCompiler, this.strict, this.substitution, ElementMatchers.isVirtual().and(this.matcher), true, false);
            }

            public WithoutSpecification onSuperCall() {
                return new ForMatchedMethod(this.methodGraphCompiler, this.strict, this.substitution, ElementMatchers.isVirtual().and(this.matcher), false, true);
            }

            @Override
            protected Substitution doStub() {
                return Substitution.ForElementMatchers.ofMethod(this.matcher, this.includeVirtualCalls, this.includeSuperCalls, Substitution.Resolver.Stubbing.INSTANCE);
            }

            @Override
            protected Substitution doReplaceWith(FieldDescription fieldDescription) {
                return Substitution.ForElementMatchers.ofMethod(this.matcher, this.includeVirtualCalls, this.includeSuperCalls, new Substitution.Resolver.FieldAccessing(fieldDescription));
            }

            @Override
            protected Substitution doReplaceWith(MethodDescription methodDescription) {
                return Substitution.ForElementMatchers.ofMethod(this.matcher, this.includeVirtualCalls, this.includeSuperCalls, new Substitution.Resolver.MethodInvoking(methodDescription));
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMatchedMethod)) {
                    return false;
                }
                ForMatchedMethod other = (ForMatchedMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                ElementMatcher<? super MethodDescription> this$matcher = this.matcher;
                ElementMatcher<? super MethodDescription> other$matcher = other.matcher;
                if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                    return false;
                }
                if (this.includeVirtualCalls != other.includeVirtualCalls) {
                    return false;
                }
                return this.includeSuperCalls == other.includeSuperCalls;
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof ForMatchedMethod;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + super.hashCode();
                ElementMatcher<? super MethodDescription> $matcher = this.matcher;
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                result = result * 59 + (this.includeVirtualCalls ? 79 : 97);
                result = result * 59 + (this.includeSuperCalls ? 79 : 97);
                return result;
            }
        }

        public static class ForMatchedField
        extends WithoutSpecification {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> matcher;
            private final boolean matchRead;
            private final boolean matchWrite;

            protected ForMatchedField(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
                this(methodGraphCompiler, strict, substitution, matcher, true, true);
            }

            protected ForMatchedField(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, ElementMatcher<? super FieldDescription.InDefinedShape> matcher, boolean matchRead, boolean matchWrite) {
                super(methodGraphCompiler, strict, substitution);
                this.matcher = matcher;
                this.matchRead = matchRead;
                this.matchWrite = matchWrite;
            }

            public WithoutSpecification onRead() {
                return new ForMatchedField(this.methodGraphCompiler, this.strict, this.substitution, this.matcher, true, false);
            }

            public WithoutSpecification onWrite() {
                return new ForMatchedField(this.methodGraphCompiler, this.strict, this.substitution, this.matcher, false, true);
            }

            @Override
            protected Substitution doStub() {
                return Substitution.ForElementMatchers.ofField(this.matcher, this.matchRead, this.matchWrite, Substitution.Resolver.Stubbing.INSTANCE);
            }

            @Override
            protected Substitution doReplaceWith(FieldDescription fieldDescription) {
                return Substitution.ForElementMatchers.ofField(this.matcher, this.matchRead, this.matchWrite, new Substitution.Resolver.FieldAccessing(fieldDescription));
            }

            @Override
            protected Substitution doReplaceWith(MethodDescription methodDescription) {
                return Substitution.ForElementMatchers.ofField(this.matcher, this.matchRead, this.matchWrite, new Substitution.Resolver.MethodInvoking(methodDescription));
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMatchedField)) {
                    return false;
                }
                ForMatchedField other = (ForMatchedField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                ElementMatcher<? super FieldDescription.InDefinedShape> this$matcher = this.matcher;
                ElementMatcher<? super FieldDescription.InDefinedShape> other$matcher = other.matcher;
                if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                    return false;
                }
                if (this.matchRead != other.matchRead) {
                    return false;
                }
                return this.matchWrite == other.matchWrite;
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof ForMatchedField;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + super.hashCode();
                ElementMatcher<? super FieldDescription.InDefinedShape> $matcher = this.matcher;
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                result = result * 59 + (this.matchRead ? 79 : 97);
                result = result * 59 + (this.matchWrite ? 79 : 97);
                return result;
            }
        }

        protected static class ForMatchedByteCodeElement
        extends WithoutSpecification {
            private final ElementMatcher<? super ByteCodeElement> matcher;

            protected ForMatchedByteCodeElement(MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, ElementMatcher<? super ByteCodeElement> matcher) {
                super(methodGraphCompiler, strict, substitution);
                this.matcher = matcher;
            }

            @Override
            protected Substitution doStub() {
                return Substitution.ForElementMatchers.of(this.matcher, Substitution.Resolver.Stubbing.INSTANCE);
            }

            @Override
            protected Substitution doReplaceWith(FieldDescription fieldDescription) {
                return Substitution.ForElementMatchers.of(this.matcher, new Substitution.Resolver.FieldAccessing(fieldDescription));
            }

            @Override
            protected Substitution doReplaceWith(MethodDescription methodDescription) {
                return Substitution.ForElementMatchers.of(this.matcher, new Substitution.Resolver.MethodInvoking(methodDescription));
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMatchedByteCodeElement)) {
                    return false;
                }
                ForMatchedByteCodeElement other = (ForMatchedByteCodeElement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                ElementMatcher<? super ByteCodeElement> this$matcher = this.matcher;
                ElementMatcher<? super ByteCodeElement> other$matcher = other.matcher;
                return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof ForMatchedByteCodeElement;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + super.hashCode();
                ElementMatcher<? super ByteCodeElement> $matcher = this.matcher;
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                return result;
            }
        }
    }
}

