/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.instrumentation;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opencensus.contrib.agent.Settings;
import io.opencensus.contrib.agent.bootstrap.TraceTrampoline;
import io.opencensus.contrib.agent.deps.bytebuddy.agent.builder.AgentBuilder;
import io.opencensus.contrib.agent.deps.bytebuddy.asm.Advice;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.DynamicType;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.JavaModule;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.instrumentation.Instrumenter;
import java.io.Closeable;

public final class UrlInstrumentation
implements Instrumenter {
    @Override
    public AgentBuilder instrument(AgentBuilder agentBuilder, Settings settings) {
        Preconditions.checkNotNull(agentBuilder, "agentBuilder");
        Preconditions.checkNotNull(settings, "settings");
        if (!settings.isEnabled("trace.java.net.URL.getContent")) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.named("java.net.URL")).transform(new Transformer());
    }

    private static class GetContent {
        private GetContent() {
        }

        @Advice.OnMethodEnter
        @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
        @MustBeClosed
        private static Closeable enter(@Advice.Origin(value="#t\\##m") String classAndMethodName) {
            return TraceTrampoline.startScopedSpan((String)classAndMethodName);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
        private static void exit(@Advice.Enter Closeable scope, @Advice.Thrown Throwable throwable) {
            TraceTrampoline.endScope((Closeable)scope, (Throwable)throwable);
        }
    }

    private static class Transformer
    implements AgentBuilder.Transformer {
        private Transformer() {
        }

        @Override
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            return builder.visit(Advice.to(GetContent.class).on(ElementMatchers.named("getContent")));
        }
    }
}

