/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.util.concurrent;

import io.opencensus.contrib.agent.deps.guava.annotations.GwtCompatible;
import io.opencensus.contrib.agent.deps.guava.base.Optional;
import io.opencensus.contrib.agent.deps.guava.collect.ImmutableCollection;
import io.opencensus.contrib.agent.deps.guava.collect.ImmutableList;
import io.opencensus.contrib.agent.deps.guava.collect.Lists;
import io.opencensus.contrib.agent.deps.guava.util.concurrent.AggregateFuture;
import io.opencensus.contrib.agent.deps.guava.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    private List<Optional<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        this.values = (List)((Object)(futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size())));
        for (int i = 0; i < futures.size(); ++i) {
            this.values.add(null);
        }
    }

    @Override
    final void collectOneValue(int index, @NullableDecl V returnValue) {
        List<Optional<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, Optional.fromNullable(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<Optional<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<Optional<V>> var1);

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public List<V> combine(List<Optional<V>> values) {
            ArrayList<Object> result = Lists.newArrayListWithCapacity(values.size());
            for (Optional<V> element : values) {
                result.add(element != null ? (Object)element.orNull() : null);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

