/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.collect;

import io.opencensus.contrib.agent.deps.guava.annotations.GwtCompatible;
import io.opencensus.contrib.agent.deps.guava.annotations.GwtIncompatible;
import io.opencensus.contrib.agent.deps.guava.collect.AbstractMapBasedMultiset;
import io.opencensus.contrib.agent.deps.guava.collect.Iterables;
import io.opencensus.contrib.agent.deps.guava.collect.Multisets;
import io.opencensus.contrib.agent.deps.guava.collect.ObjectCountHashMap;

@GwtCompatible(serializable=true, emulated=true)
public class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return HashMultiset.create(3);
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    HashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    void init(int distinctElements) {
        this.backingMap = new ObjectCountHashMap(distinctElements);
    }
}

