/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant;

import io.opencensus.contrib.agent.deps.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackSize;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.JavaConstant;

@HashCodeAndEqualsPlugin.Enhance
public class JavaConstantValue
implements StackManipulation {
    private final JavaConstant javaConstant;

    public JavaConstantValue(JavaConstant javaConstant) {
        this.javaConstant = javaConstant;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.javaConstant.asConstantPoolValue());
        return StackSize.SINGLE.toIncreasingSize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.javaConstant.equals(((JavaConstantValue)object).javaConstant);
    }

    public int hashCode() {
        return 17 * 31 + this.javaConstant.hashCode();
    }
}

