/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant;

import io.opencensus.contrib.agent.deps.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackSize;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;

public enum DoubleConstant implements StackManipulation
{
    ZERO(14),
    ONE(15);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private DoubleConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    implements StackManipulation {
        private final double value;

        protected ConstantPool(double value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((ConstantPool)object).value;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.value);
            return 17 * 31 + (int)(l ^ l >>> 32);
        }
    }
}

