/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent;

import io.opencensus.contrib.agent.deps.config.Config;
import io.opencensus.contrib.agent.deps.config.ConfigFactory;
import io.opencensus.contrib.agent.deps.guava.annotations.VisibleForTesting;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.base.Strings;

public class Settings {
    private static final String CONFIG_ROOT = "opencensus.contrib.agent";
    private final Config config;

    @VisibleForTesting
    public Settings(Config config) {
        this.config = Preconditions.checkNotNull(config);
    }

    static Settings load() {
        return new Settings(Settings.readConfig());
    }

    private static Config readConfig() {
        Config config = ConfigFactory.load();
        config.checkValid(ConfigFactory.defaultReference(), CONFIG_ROOT);
        return config.getConfig(CONFIG_ROOT);
    }

    public boolean isEnabled(String featurePath) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(featurePath));
        return this.config.getConfig(featurePath).getBoolean("enabled");
    }
}

