/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.implementation.attribute;

import io.opencensus.contrib.agent.deps.bytebuddy.description.annotation.AnnotationDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.annotation.AnnotationList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeList;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.attribute.AnnotationAppender;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.attribute.AnnotationValueFilter;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.ClassVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface TypeAttributeAppender {
    public void apply(ClassVisitor var1, TypeDescription var2, AnnotationValueFilter var3);

    public static class Compound
    implements TypeAttributeAppender {
        private final List<TypeAttributeAppender> typeAttributeAppenders = new ArrayList<TypeAttributeAppender>();

        public Compound(TypeAttributeAppender ... typeAttributeAppender) {
            this(Arrays.asList(typeAttributeAppender));
        }

        public Compound(List<? extends TypeAttributeAppender> typeAttributeAppenders) {
            for (TypeAttributeAppender typeAttributeAppender : typeAttributeAppenders) {
                if (typeAttributeAppender instanceof Compound) {
                    this.typeAttributeAppenders.addAll(((Compound)typeAttributeAppender).typeAttributeAppenders);
                    continue;
                }
                if (typeAttributeAppender instanceof NoOp) continue;
                this.typeAttributeAppenders.add(typeAttributeAppender);
            }
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            for (TypeAttributeAppender typeAttributeAppender : this.typeAttributeAppenders) {
                typeAttributeAppender.apply(classVisitor, instrumentedType, annotationValueFilter);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Compound)) {
                return false;
            }
            Compound other = (Compound)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<TypeAttributeAppender> this$typeAttributeAppenders = this.typeAttributeAppenders;
            List<TypeAttributeAppender> other$typeAttributeAppenders = other.typeAttributeAppenders;
            return !(this$typeAttributeAppenders == null ? other$typeAttributeAppenders != null : !((Object)this$typeAttributeAppenders).equals(other$typeAttributeAppenders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Compound;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TypeAttributeAppender> $typeAttributeAppenders = this.typeAttributeAppenders;
            result = result * 59 + ($typeAttributeAppenders == null ? 43 : ((Object)$typeAttributeAppenders).hashCode());
            return result;
        }
    }

    public static class Explicit
    implements TypeAttributeAppender {
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Explicit)) {
                return false;
            }
            Explicit other = (Explicit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<? extends AnnotationDescription> this$annotations = this.annotations;
            List<? extends AnnotationDescription> other$annotations = other.annotations;
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Explicit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<? extends AnnotationDescription> $annotations = this.annotations;
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }
    }

    public static enum ForInstrumentedType implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            annotationAppender = AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, true, instrumentedType.getTypeVariables());
            TypeDescription.Generic superClass = instrumentedType.getSuperClass();
            if (superClass != null) {
                annotationAppender = superClass.accept(AnnotationAppender.ForTypeAnnotations.ofSuperClass(annotationAppender, annotationValueFilter));
            }
            int interfaceIndex = 0;
            for (TypeDescription.Generic interfaceType : instrumentedType.getInterfaces()) {
                annotationAppender = interfaceType.accept(AnnotationAppender.ForTypeAnnotations.ofInterfaceType(annotationAppender, annotationValueFilter, interfaceIndex++));
            }
            for (AnnotationDescription annotation : instrumentedType.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
        }

        public static class Differentiating
        implements TypeAttributeAppender {
            private final int annotationIndex;
            private final int typeVariableIndex;
            private final int interfaceTypeIndex;

            public Differentiating(TypeDescription typeDescription) {
                this(typeDescription.getDeclaredAnnotations().size(), typeDescription.getTypeVariables().size(), typeDescription.getInterfaces().size());
            }

            protected Differentiating(int annotationIndex, int typeVariableIndex, int interfaceTypeIndex) {
                this.annotationIndex = annotationIndex;
                this.typeVariableIndex = typeVariableIndex;
                this.interfaceTypeIndex = interfaceTypeIndex;
            }

            @Override
            public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
                AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
                AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, true, this.typeVariableIndex, instrumentedType.getTypeVariables());
                TypeList.Generic interfaceTypes = instrumentedType.getInterfaces();
                int interfaceTypeIndex = this.interfaceTypeIndex;
                for (TypeDescription.Generic interfaceType : (TypeList.Generic)interfaceTypes.subList(this.interfaceTypeIndex, interfaceTypes.size())) {
                    annotationAppender = interfaceType.accept(AnnotationAppender.ForTypeAnnotations.ofInterfaceType(annotationAppender, annotationValueFilter, interfaceTypeIndex++));
                }
                AnnotationList declaredAnnotations = instrumentedType.getDeclaredAnnotations();
                for (AnnotationDescription annotationDescription : (AnnotationList)declaredAnnotations.subList(this.annotationIndex, declaredAnnotations.size())) {
                    annotationAppender = annotationAppender.append(annotationDescription, annotationValueFilter);
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Differentiating)) {
                    return false;
                }
                Differentiating other = (Differentiating)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.annotationIndex != other.annotationIndex) {
                    return false;
                }
                if (this.typeVariableIndex != other.typeVariableIndex) {
                    return false;
                }
                return this.interfaceTypeIndex == other.interfaceTypeIndex;
            }

            protected boolean canEqual(Object other) {
                return other instanceof Differentiating;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.annotationIndex;
                result = result * 59 + this.typeVariableIndex;
                result = result * 59 + this.interfaceTypeIndex;
                return result;
            }
        }
    }

    public static enum NoOp implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
        }
    }
}

