/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.ClassFileLocator;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.Nexus;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.ClassInjector;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.LoadedTypeInitializer;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.ByteCodeAppender;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.Removal;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant.ClassConstant;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant.NullConstant;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant.TextConstant;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.member.MethodInvocation;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;

public class NexusAccessor {
    private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
    private final ReferenceQueue<? super ClassLoader> referenceQueue;

    public NexusAccessor() {
        this(Nexus.NO_QUEUE);
    }

    public NexusAccessor(ReferenceQueue<? super ClassLoader> referenceQueue) {
        this.referenceQueue = referenceQueue;
    }

    public static boolean isAlive() {
        return DISPATCHER.isAlive();
    }

    public static void clean(Reference<? extends ClassLoader> reference) {
        DISPATCHER.clean(reference);
    }

    public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
        if (loadedTypeInitializer.isAlive()) {
            DISPATCHER.register(name, classLoader, this.referenceQueue, identification, loadedTypeInitializer);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NexusAccessor)) {
            return false;
        }
        NexusAccessor other = (NexusAccessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReferenceQueue<? super ClassLoader> this$referenceQueue = this.referenceQueue;
        ReferenceQueue<? super ClassLoader> other$referenceQueue = other.referenceQueue;
        return !(this$referenceQueue == null ? other$referenceQueue != null : !this$referenceQueue.equals(other$referenceQueue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NexusAccessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReferenceQueue<? super ClassLoader> $referenceQueue = this.referenceQueue;
        result = result * 59 + ($referenceQueue == null ? 43 : $referenceQueue.hashCode());
        return result;
    }

    protected static interface Dispatcher {
        public boolean isAlive();

        public void clean(Reference<? extends ClassLoader> var1);

        public void register(String var1, ClassLoader var2, ReferenceQueue<? super ClassLoader> var3, int var4, LoadedTypeInitializer var5);

        public static class Unavailable
        implements Dispatcher {
            private final Exception exception;

            protected Unavailable(Exception exception) {
                this.exception = exception;
            }

            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public void clean(Reference<? extends ClassLoader> reference) {
                throw new IllegalStateException("Could not initialize Nexus accessor", this.exception);
            }

            @Override
            public void register(String name, ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                throw new IllegalStateException("Could not initialize Nexus accessor", this.exception);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Unavailable)) {
                    return false;
                }
                Unavailable other = (Unavailable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Exception this$exception = this.exception;
                Exception other$exception = other.exception;
                return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Unavailable;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Exception $exception = this.exception;
                result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
                return result;
            }
        }

        public static class Available
        implements Dispatcher {
            private static final Object STATIC_METHOD = null;
            private final Method register;
            private final Method clean;

            protected Available(Method register, Method clean) {
                this.register = register;
                this.clean = clean;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public void clean(Reference<? extends ClassLoader> reference) {
                try {
                    this.clean.invoke(STATIC_METHOD, reference);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access: " + this.clean, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke: " + this.clean, exception.getCause());
                }
            }

            @Override
            public void register(String name, ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                try {
                    this.register.invoke(STATIC_METHOD, name, classLoader, referenceQueue, identification, loadedTypeInitializer);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access: " + this.register, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke: " + this.register, exception.getCause());
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Available)) {
                    return false;
                }
                Available other = (Available)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Method this$register = this.register;
                Method other$register = other.register;
                if (this$register == null ? other$register != null : !((Object)this$register).equals(other$register)) {
                    return false;
                }
                Method this$clean = this.clean;
                Method other$clean = other.clean;
                return !(this$clean == null ? other$clean != null : !((Object)this$clean).equals(other$clean));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Available;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Method $register = this.register;
                result = result * 59 + ($register == null ? 43 : ((Object)$register).hashCode());
                Method $clean = this.clean;
                result = result * 59 + ($clean == null ? 43 : ((Object)$clean).hashCode());
                return result;
            }
        }

        public static enum CreationAction implements PrivilegedAction<Dispatcher>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public Dispatcher run() {
                if (Boolean.getBoolean("io.opencensus.contrib.agent.deps.bytebuddy.nexus.disabled")) {
                    return new Unavailable(new IllegalStateException("Nexus injection was explicitly disabled"));
                }
                try {
                    Class<?> nexusType = new ClassInjector.UsingReflection(ClassLoader.getSystemClassLoader(), ClassLoadingStrategy.NO_PROTECTION_DOMAIN).inject(Collections.singletonMap(new TypeDescription.ForLoadedType(Nexus.class), ClassFileLocator.ForClassLoader.read(Nexus.class).resolve())).get(new TypeDescription.ForLoadedType(Nexus.class));
                    return new Available(nexusType.getMethod("register", String.class, ClassLoader.class, ReferenceQueue.class, Integer.TYPE, Object.class), nexusType.getMethod("clean", Reference.class));
                }
                catch (Exception exception) {
                    try {
                        Class<?> nexusType = ClassLoader.getSystemClassLoader().loadClass(Nexus.class.getName());
                        return new Available(nexusType.getMethod("register", String.class, ClassLoader.class, ReferenceQueue.class, Integer.TYPE, Object.class), nexusType.getMethod("clean", Reference.class));
                    }
                    catch (Exception ignored) {
                        return new Unavailable(exception);
                    }
                }
            }
        }
    }

    public static class InitializationAppender
    implements ByteCodeAppender {
        private final int identification;

        public InitializationAppender(int identification) {
            this.identification = identification;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            try {
                return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]))), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(ClassLoader.class.getMethod("loadClass", String.class))), new TextConstant("initialize"), ArrayFactory.forType(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class)).withValues(Arrays.asList(ClassConstant.of(TypeDescription.CLASS), ClassConstant.of(new TypeDescription.ForLoadedType(Integer.TYPE)))), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Class.class.getMethod("getMethod", String.class, Class[].class))), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(Arrays.asList(ClassConstant.of(instrumentedMethod.getDeclaringType().asErasure()), new StackManipulation.Compound(IntegerConstant.forValue(this.identification), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Integer.class.getMethod("valueOf", Integer.TYPE)))))), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Method.class.getMethod("invoke", Object.class, Object[].class))), Removal.SINGLE)).apply(methodVisitor, implementationContext, instrumentedMethod);
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate method", exception);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializationAppender)) {
                return false;
            }
            InitializationAppender other = (InitializationAppender)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.identification == other.identification;
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitializationAppender;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.identification;
            return result;
        }
    }
}

