/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.opencensus.common.Timestamp;
import io.opencensus.trace.NetworkEvent;
import javax.annotation.Nullable;

final class AutoValue_NetworkEvent
extends NetworkEvent {
    private final Timestamp kernelTimestamp;
    private final NetworkEvent.Type type;
    private final long messageId;
    private final long messageSize;

    private AutoValue_NetworkEvent(@Nullable Timestamp kernelTimestamp, NetworkEvent.Type type, long messageId, long messageSize) {
        this.kernelTimestamp = kernelTimestamp;
        this.type = type;
        this.messageId = messageId;
        this.messageSize = messageSize;
    }

    @Override
    @Nullable
    public Timestamp getKernelTimestamp() {
        return this.kernelTimestamp;
    }

    @Override
    public NetworkEvent.Type getType() {
        return this.type;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public long getMessageSize() {
        return this.messageSize;
    }

    public String toString() {
        return "NetworkEvent{kernelTimestamp=" + this.kernelTimestamp + ", type=" + (Object)((Object)this.type) + ", messageId=" + this.messageId + ", messageSize=" + this.messageSize + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEvent) {
            NetworkEvent that = (NetworkEvent)o;
            return (this.kernelTimestamp == null ? that.getKernelTimestamp() == null : this.kernelTimestamp.equals(that.getKernelTimestamp())) && this.type.equals((Object)that.getType()) && this.messageId == that.getMessageId() && this.messageSize == that.getMessageSize();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.kernelTimestamp == null ? 0 : this.kernelTimestamp.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.messageId >>> 32 ^ this.messageId));
        h *= 1000003;
        h = (int)((long)h ^ (this.messageSize >>> 32 ^ this.messageSize));
        return h;
    }

    static final class Builder
    extends NetworkEvent.Builder {
        private Timestamp kernelTimestamp;
        private NetworkEvent.Type type;
        private Long messageId;
        private Long messageSize;

        Builder() {
        }

        @Override
        public NetworkEvent.Builder setKernelTimestamp(@Nullable Timestamp kernelTimestamp) {
            this.kernelTimestamp = kernelTimestamp;
            return this;
        }

        @Override
        NetworkEvent.Builder setType(NetworkEvent.Type type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        NetworkEvent.Builder setMessageId(long messageId) {
            this.messageId = messageId;
            return this;
        }

        @Override
        public NetworkEvent.Builder setMessageSize(long messageSize) {
            this.messageSize = messageSize;
            return this;
        }

        @Override
        public NetworkEvent build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.messageId == null) {
                missing = missing + " messageId";
            }
            if (this.messageSize == null) {
                missing = missing + " messageSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_NetworkEvent(this.kernelTimestamp, this.type, this.messageId, this.messageSize);
        }
    }
}

