/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import com.google.common.io.BaseEncoding;
import io.opencensus.internal.Utils;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId
implements Comparable<TraceId> {
    public static final int SIZE = 16;
    private static final int HEX_SIZE = 32;
    public static final TraceId INVALID = new TraceId(new byte[16]);
    private final byte[] bytes;

    private TraceId(byte[] bytes) {
        this.bytes = bytes;
    }

    public static TraceId fromBytes(byte[] buffer) {
        Utils.checkNotNull(buffer, "buffer");
        Utils.checkArgument(buffer.length == 16, "Invalid size: expected %s, got %s", 16, buffer.length);
        byte[] bytesCopied = Arrays.copyOf(buffer, 16);
        return new TraceId(bytesCopied);
    }

    public static TraceId fromBytes(byte[] src, int srcOffset) {
        byte[] bytes = new byte[16];
        System.arraycopy(src, srcOffset, bytes, 0, 16);
        return new TraceId(bytes);
    }

    public static TraceId fromLowerBase16(CharSequence src) {
        Utils.checkArgument(src.length() == 32, "Invalid size: expected %s, got %s", 32, src.length());
        byte[] bytes = BaseEncoding.base16().lowerCase().decode(src);
        return new TraceId(bytes);
    }

    public static TraceId generateRandomId(Random random) {
        byte[] bytes = new byte[16];
        do {
            random.nextBytes(bytes);
        } while (Arrays.equals(bytes, TraceId.INVALID.bytes));
        return new TraceId(bytes);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, 16);
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        System.arraycopy(this.bytes, 0, dest, destOffset, 16);
    }

    public boolean isValid() {
        return !Arrays.equals(this.bytes, TraceId.INVALID.bytes);
    }

    public String toLowerBase16() {
        return TraceId.toLowerBase16(this.bytes);
    }

    private static String toLowerBase16(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    public long getLowerLong() {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(this.bytes[i] & 0xFF);
        }
        if (result < 0L) {
            return -result;
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceId)) {
            return false;
        }
        TraceId that = (TraceId)obj;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return "TraceId{traceId=" + TraceId.toLowerBase16(this.bytes) + "}";
    }

    @Override
    public int compareTo(TraceId that) {
        for (int i = 0; i < 16; ++i) {
            if (this.bytes[i] == that.bytes[i]) continue;
            return this.bytes[i] < that.bytes[i] ? -1 : 1;
        }
        return 0;
    }
}

