/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.processor;

import io.openapiprocessor.core.converter.ApiConverter;
import io.openapiprocessor.core.converter.ApiOptions;
import io.openapiprocessor.core.converter.OptionsConverter;
import io.openapiprocessor.core.framework.Framework;
import io.openapiprocessor.core.framework.FrameworkAnnotations;
import io.openapiprocessor.core.model.Api;
import io.openapiprocessor.core.parser.OpenApi;
import io.openapiprocessor.core.parser.OpenApiParser;
import io.openapiprocessor.core.writer.SourceFormatter;
import io.openapiprocessor.core.writer.WriterFactory;
import io.openapiprocessor.core.writer.java.ApiWriter;
import io.openapiprocessor.core.writer.java.BeanValidationFactory;
import io.openapiprocessor.core.writer.java.BeanValidationFormat;
import io.openapiprocessor.core.writer.java.DataTypeWriter;
import io.openapiprocessor.core.writer.java.DataTypeWriterBase;
import io.openapiprocessor.core.writer.java.DataTypeWriterPojo;
import io.openapiprocessor.core.writer.java.DataTypeWriterRecord;
import io.openapiprocessor.core.writer.java.DefaultImportFilter;
import io.openapiprocessor.core.writer.java.GeneratedInfo;
import io.openapiprocessor.core.writer.java.GeneratedWriter;
import io.openapiprocessor.core.writer.java.GeneratedWriterImpl;
import io.openapiprocessor.core.writer.java.GoogleFormatter;
import io.openapiprocessor.core.writer.java.ImportFilter;
import io.openapiprocessor.core.writer.java.InterfaceDataTypeWriter;
import io.openapiprocessor.core.writer.java.InterfaceWriter;
import io.openapiprocessor.core.writer.java.JavaDocWriter;
import io.openapiprocessor.core.writer.java.MappingAnnotationWriter;
import io.openapiprocessor.core.writer.java.MethodWriter;
import io.openapiprocessor.core.writer.java.ParameterAnnotationWriter;
import io.openapiprocessor.core.writer.java.StringEnumWriter;
import io.openapiprocessor.spring.processor.ProcessingException;
import io.openapiprocessor.spring.processor.SpringFramework;
import io.openapiprocessor.spring.processor.SpringFrameworkAnnotations;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r\u0012\u0002\b\u00030\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r\u0012\u0002\b\u00030\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/openapiprocessor/spring/processor/SpringProcessor;", "", "writerFactory", "Lio/openapiprocessor/core/writer/WriterFactory;", "(Lio/openapiprocessor/core/writer/WriterFactory;)V", "log", "Lorg/slf4j/Logger;", "testMode", "", "convertOptions", "Lio/openapiprocessor/core/converter/ApiOptions;", "processorOptions", "", "", "createGeneratedInfo", "Lio/openapiprocessor/core/writer/java/GeneratedInfo;", "options", "enableTestMode", "", "getValidationFormat", "Lio/openapiprocessor/core/writer/java/BeanValidationFormat;", "run", "", "openapi-processor-spring"})
public final class SpringProcessor {
    @NotNull
    private final WriterFactory writerFactory;
    @NotNull
    private final Logger log;
    private boolean testMode;

    public SpringProcessor(@NotNull WriterFactory writerFactory) {
        Intrinsics.checkNotNullParameter((Object)writerFactory, (String)"writerFactory");
        this.writerFactory = writerFactory;
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    public final void run(@NotNull Map<String, ?> processorOptions) {
        Intrinsics.checkNotNullParameter(processorOptions, (String)"processorOptions");
        try {
            OpenApiParser parser = new OpenApiParser();
            OpenApi openapi = parser.parse(processorOptions);
            if (processorOptions.get("showWarnings") != null) {
                openapi.printWarnings();
            }
            SpringFramework framework = new SpringFramework();
            SpringFrameworkAnnotations annotations = new SpringFrameworkAnnotations();
            ApiOptions options = this.convertOptions(processorOptions);
            ApiConverter cv = new ApiConverter(options, (Framework)framework);
            Api api = cv.convert(openapi);
            GeneratedInfo generatedInfo = this.createGeneratedInfo(options);
            GeneratedWriterImpl generatedWriter = new GeneratedWriterImpl(generatedInfo, options);
            BeanValidationFactory beanValidations = new BeanValidationFactory(this.getValidationFormat(options));
            JavaDocWriter javaDocWriter = new JavaDocWriter();
            ApiWriter writer = new ApiWriter(options, (GeneratedWriter)generatedWriter, new InterfaceWriter(options, (GeneratedWriter)generatedWriter, new MethodWriter(options, (MappingAnnotationWriter)new io.openapiprocessor.spring.writer.java.MappingAnnotationWriter(annotations), (ParameterAnnotationWriter)new io.openapiprocessor.spring.writer.java.ParameterAnnotationWriter(annotations), beanValidations, javaDocWriter), (FrameworkAnnotations)annotations, beanValidations, (ImportFilter)new DefaultImportFilter()), (DataTypeWriter)(Intrinsics.areEqual((Object)options.getModelType(), (Object)"record") ? (DataTypeWriterBase)new DataTypeWriterRecord(options, (GeneratedWriter)generatedWriter, beanValidations, javaDocWriter) : (DataTypeWriterBase)new DataTypeWriterPojo(options, (GeneratedWriter)generatedWriter, beanValidations, javaDocWriter)), new StringEnumWriter((GeneratedWriter)generatedWriter), new InterfaceDataTypeWriter(options, (GeneratedWriter)generatedWriter, javaDocWriter), (SourceFormatter)new GoogleFormatter(), this.writerFactory);
            writer.write(api);
        }
        catch (Exception ex) {
            this.log.error("processing failed!", (Throwable)ex);
            throw new ProcessingException(ex);
        }
    }

    private final GeneratedInfo createGeneratedInfo(ApiOptions options) {
        String version = "2023.4";
        String date = OffsetDateTime.now().toString();
        if (!options.getGeneratedDate()) {
            date = null;
        }
        if (this.testMode) {
            version = "test";
            date = null;
        }
        return new GeneratedInfo("openapi-processor-spring", version, date, null, 8, null);
    }

    public final void enableTestMode() {
        this.testMode = true;
    }

    private final ApiOptions convertOptions(Map<String, ?> processorOptions) {
        OptionsConverter optionsConverter = new OptionsConverter(false, 1, null);
        Intrinsics.checkNotNull(processorOptions, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        ApiOptions options = optionsConverter.convertOptions(processorOptions);
        options.validate();
        return options;
    }

    private final BeanValidationFormat getValidationFormat(ApiOptions options) {
        BeanValidationFormat beanValidationFormat;
        String format = options.getBeanValidationFormat();
        if (format != null) {
            String string = format.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            beanValidationFormat = BeanValidationFormat.valueOf((String)string);
        } else {
            beanValidationFormat = BeanValidationFormat.JAVAX;
        }
        return beanValidationFormat;
    }
}

