/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.maven;

import io.openapiprocessor.api.v1.OpenApiProcessor;
import io.openapiprocessor.maven.ProcessorLoader;
import java.util.Map;
import java.util.Optional;

class ProcessorRunner {
    private final String processorName;
    private final Map<String, ?> processorProps;

    ProcessorRunner(String processorName, Map<String, ?> processorProps) {
        this.processorName = processorName;
        this.processorProps = processorProps;
    }

    void run() {
        Optional<OpenApiProcessor> processorV1 = ProcessorLoader.findProcessorV1(this.processorName, this.getClass().getClassLoader());
        if (processorV1.isPresent()) {
            processorV1.get().run(this.processorProps);
            return;
        }
        Optional<io.openapiprocessor.api.OpenApiProcessor> processor = ProcessorLoader.findProcessor(this.processorName, this.getClass().getClassLoader());
        if (processor.isPresent()) {
            processor.get().run(this.processorProps);
            return;
        }
        Optional<com.github.hauner.openapi.api.OpenApiProcessor> processorOld = ProcessorLoader.findProcessorOld(this.processorName, this.getClass().getClassLoader());
        processorOld.ifPresent(openApiProcessor -> openApiProcessor.run(this.processorProps));
    }
}

