/*
 * Decompiled with CFR 0.152.
 */
package com.github.hauner.openapi.json.processor;

import io.openapiprocessor.api.OpenApiProcessor;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001a\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/github/hauner/openapi/json/processor/JsonProcessor;", "Lio/openapiprocessor/api/OpenApiProcessor;", "()V", "getName", "", "run", "", "options", "", "toURL", "Ljava/net/URL;", "source", "openapi-processor-json"})
public final class JsonProcessor
implements OpenApiProcessor {
    @NotNull
    public String getName() {
        return "json";
    }

    public void run(@NotNull Map<String, ?> options) {
        String targetDir;
        String apiPath;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Object obj = options.get("apiPath");
        String string = apiPath = obj != null ? obj.toString() : null;
        if (apiPath == null) {
            String string2 = "openapi-processor-json: missing apiPath!";
            boolean bl = false;
            System.out.println((Object)string2);
            return;
        }
        apiPath = this.toURL(apiPath).toString();
        Object obj2 = options.get("targetDir");
        String string3 = targetDir = obj2 != null ? obj2.toString() : null;
        if (targetDir == null) {
            String string4 = "openapi-processor-json: missing targetDir!";
            boolean bl = false;
            System.out.println((Object)string4);
            return;
        }
        targetDir = this.toURL(targetDir).toString();
        ParseOptions opts = new ParseOptions();
        SwaggerParseResult swaggerParseResult = new OpenAPIV3Parser().readLocation(apiPath, null, opts);
        Intrinsics.checkNotNullExpressionValue((Object)swaggerParseResult, (String)"OpenAPIV3Parser()\n      \u2026tion(apiPath, null, opts)");
        SwaggerParseResult result = swaggerParseResult;
        String json = Json.pretty((Object)result.getOpenAPI());
        json = json + "\n";
        Path p = Paths.get(new URL(targetDir).toURI());
        Path dir = Files.createDirectories(p, new FileAttribute[0]);
        Path targetPath = dir.resolve("openapi.json");
        File file = targetPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"targetPath.toFile()");
        String string5 = json;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"json");
        FilesKt.writeText$default((File)file, (String)string5, null, (int)2, null);
    }

    private final URL toURL(String source) {
        try {
            return new URL(source);
        }
        catch (Exception exception) {
            try {
                URL uRL = Paths.get(source, new String[0]).normalize().toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"Paths.get(source)\n      \u2026                .toURL ()");
                return uRL;
            }
            catch (Exception e) {
                throw (Throwable)e;
            }
        }
    }
}

