/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.converter;

import io.openapiparser.Factory;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.TypeMismatchException;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Types;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ObjectNullableConverter<@UnknownKeyFor T>
implements PropertyConverter<T> {
    private final @UnknownKeyFor @NonNull @Initialized Scope scope;
    private final @UnknownKeyFor @NonNull @Initialized Factory<T> factory;

    public ObjectNullableConverter(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized Factory<T> factory) {
        this.scope = scope;
        this.factory = factory;
    }

    public @Nullable T convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        Bucket bucket = this.getBucket(value, location);
        if (bucket == null) {
            return null;
        }
        return this.factory.create(bucket);
    }

    private @Nullable @UnknownKeyFor @Initialized Bucket getBucket(@Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        if (value == null) {
            return null;
        }
        if (!Types.isMap((Object)value)) {
            throw new TypeMismatchException(location, Map.class);
        }
        return new Bucket(this.scope, location, Types.asMap((Object)value));
    }
}

