/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.converter;

import io.openapiprocessor.jsonschema.converter.PropertiesConverter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ExtensionsConverter
implements PropertiesConverter<Map<String, Object>> {
    private static final @UnknownKeyFor @NonNull @Initialized Pattern EXTENSION_PATTERN = Pattern.compile("^x-");

    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> convert(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties, @UnknownKeyFor @NonNull @Initialized String location) {
        LinkedHashMap extensions = new LinkedHashMap();
        properties.forEach((property, value) -> {
            if (this.isExtension((String)property)) {
                extensions.put(property, value);
            }
        });
        return Collections.unmodifiableMap(extensions);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isExtension(@UnknownKeyFor @NonNull @Initialized String property) {
        return EXTENSION_PATTERN.matcher(property).find();
    }
}

