/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser;

import io.openapiparser.Context;
import io.openapiparser.Factory;
import io.openapiparser.converter.ExtensionsConverter;
import io.openapiparser.converter.MapObjectsOrEmptyConverter;
import io.openapiparser.converter.MapStringsOrEmptyConverter;
import io.openapiparser.converter.ObjectNotNullConverter;
import io.openapiparser.converter.ObjectsOrEmptyConverter;
import io.openapiparser.converter.StringsNullableConverter;
import io.openapiparser.converter.StringsOrEmptyConverter;
import io.openapiparser.support.Experimental;
import io.openapiprocessor.jsonschema.converter.BooleanConverter;
import io.openapiprocessor.jsonschema.converter.IntegerConverter;
import io.openapiprocessor.jsonschema.converter.MapSetStringsOrEmptyConverter;
import io.openapiprocessor.jsonschema.converter.NoValueException;
import io.openapiprocessor.jsonschema.converter.NumberConverter;
import io.openapiprocessor.jsonschema.converter.PropertiesConverter;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.StringNotNullConverter;
import io.openapiprocessor.jsonschema.converter.StringNullableConverter;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.support.Null;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Properties {
    protected final @UnknownKeyFor @NonNull @Initialized Context context;
    protected final @UnknownKeyFor @NonNull @Initialized Bucket bucket;

    protected Properties(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        this.context = context;
        this.bucket = bucket;
    }

    @Experimental
    public @Nullable @UnknownKeyFor @Initialized Object getRawValueOf(@UnknownKeyFor @NonNull @Initialized String pointer) {
        return this.bucket.getRawValueValue(JsonPointer.from((String)pointer));
    }

    @Experimental
    public <T> @Nullable T getValueOf(@UnknownKeyFor @NonNull @Initialized String pointer, @UnknownKeyFor @NonNull @Initialized Class<T> target) {
        Object rawValue = this.getRawValueOf(pointer);
        if (rawValue == null) {
            throw new NoValueException(pointer);
        }
        return new ObjectNotNullConverter<T>(this.bucket.getScope(), new Factory<T>(this.context, target)).convert("unused", rawValue, pointer);
    }

    protected @Nullable @UnknownKeyFor @Initialized Object getRawValue(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.bucket.getRawValue(property);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasProperty(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.bucket.hasProperty(property);
    }

    protected @Nullable @UnknownKeyFor @Initialized String getStringOrNull(@UnknownKeyFor @NonNull @Initialized String property) {
        return (String)this.bucket.convert(property, (PropertyConverter)new StringNullableConverter());
    }

    protected @UnknownKeyFor @NonNull @Initialized String getStringOrThrow(@UnknownKeyFor @NonNull @Initialized String property) {
        return (String)Null.nonNull((Object)((String)this.bucket.convert(property, (PropertyConverter)new StringNotNullConverter())));
    }

    protected @Nullable @UnknownKeyFor @Initialized Number getNumberOrNull(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Number)this.bucket.convert(property, (PropertyConverter)new NumberConverter());
    }

    protected @Nullable @UnknownKeyFor @Initialized Integer getIntegerOrNull(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Integer)this.bucket.convert(property, (PropertyConverter)new IntegerConverter());
    }

    protected @UnknownKeyFor @NonNull @Initialized Integer getIntegerOrDefault(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized int defaultValue) {
        Integer value = (Integer)this.bucket.convert(property, (PropertyConverter)new IntegerConverter());
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected @Nullable @UnknownKeyFor @Initialized Boolean getBooleanOrNull(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Boolean)this.bucket.convert(property, (PropertyConverter)new BooleanConverter());
    }

    protected @UnknownKeyFor @NonNull @Initialized Boolean getBooleanOrFalse(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.getBooleanOrDefault(property, false);
    }

    protected @UnknownKeyFor @NonNull @Initialized Boolean getBooleanOrDefault(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized boolean defaultValue) {
        Boolean value = this.getBooleanOrNull(property);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected <T> @Nullable T getObjectOrNull(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return this.getObjectOrNull(this.bucket, property, clazz);
    }

    protected <T> T getObjectOrThrow(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return this.getObjectOrThrow(this.bucket, property, clazz);
    }

    protected <T> @UnknownKeyFor @NonNull @Initialized Collection<T> getObjectsOrEmpty(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return (Collection)Null.nonNull((Object)((Collection)this.bucket.convert(property, new ObjectsOrEmptyConverter<T>(this.bucket.getScope(), new Factory<T>(this.context, clazz)))));
    }

    protected @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getStringsOrEmpty(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Collection)Null.nonNull((Object)((Collection)this.bucket.convert(property, (PropertyConverter)new StringsOrEmptyConverter())));
    }

    protected @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getStringsOrNull(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Collection)this.bucket.convert(property, (PropertyConverter)new StringsNullableConverter());
    }

    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getMapStringsOrEmpty(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Map)Null.nonNull((Object)((Map)this.bucket.convert(property, (PropertyConverter)new MapStringsOrEmptyConverter())));
    }

    protected <T> @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> getMapObjectsOrEmpty(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        LinkedHashMap objects = new LinkedHashMap();
        this.bucket.forEachProperty(property -> objects.put(property, this.getObjectOrThrow(this.bucket, (String)property, clazz)));
        return Collections.unmodifiableMap(objects);
    }

    protected <T> @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> getMapObjectsOrEmpty(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return (Map)Null.nonNull((Object)((Map)this.bucket.convert(property, new MapObjectsOrEmptyConverter<T>(this.bucket.getScope(), new Factory<T>(this.context, clazz)))));
    }

    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> getMapSetStringsOrEmpty(@UnknownKeyFor @NonNull @Initialized String property) {
        return (Map)Null.nonNull((Object)((Map)this.bucket.convert(property, (PropertyConverter)new MapSetStringsOrEmptyConverter())));
    }

    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getExtensions() {
        return (Map)Null.nonNull((Object)((Map)this.bucket.convert((PropertiesConverter)new ExtensionsConverter())));
    }

    protected <T> @Nullable T getRefObject(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Bucket ref = this.context.getRefObjectOrNull(this.bucket);
        if (ref == null) {
            return null;
        }
        return new Factory<T>(this.context, clazz).create(ref);
    }

    protected <T> T getRefObjectOrThrow(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Bucket refObjectOrThrow = this.context.getRefObjectOrThrow(this.bucket);
        return new Factory<T>(this.context, clazz).create(refObjectOrThrow);
    }

    private <T> @Nullable T getObjectOrNull(@UnknownKeyFor @NonNull @Initialized Bucket source, @UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Bucket value = source.getBucket(property);
        if (value == null) {
            return null;
        }
        return new Factory<T>(this.context, clazz).create(value);
    }

    private <T> T getObjectOrThrow(@UnknownKeyFor @NonNull @Initialized Bucket source, @UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Bucket value = source.getBucket(property);
        if (value == null) {
            throw new NoValueException(property);
        }
        return new Factory<T>(this.context, clazz).create(value);
    }
}

