/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser;

import io.openapiparser.Context;
import io.openapiparser.OpenApiResult;
import io.openapiparser.OpenApiResult30;
import io.openapiparser.OpenApiResult31;
import io.openapiparser.ParserException;
import io.openapiparser.UnknownVersionException;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.StringNotNullConverter;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.DocumentLoader;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.Resolver;
import io.openapiprocessor.jsonschema.schema.ResolverResult;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Null;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OpenApiParser {
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents;
    private final @UnknownKeyFor @NonNull @Initialized DocumentLoader loader;

    public OpenApiParser(@UnknownKeyFor @NonNull @Initialized DocumentStore documents, @UnknownKeyFor @NonNull @Initialized DocumentLoader loader) {
        this.documents = documents;
        this.loader = loader;
    }

    public @UnknownKeyFor @NonNull @Initialized OpenApiResult parse(@UnknownKeyFor @NonNull @Initialized URI baseUri) {
        try {
            return this.parse(baseUri, this.loader.loadDocument(baseUri));
        }
        catch (Exception e) {
            throw new ParserException(baseUri, e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized OpenApiResult parse(@UnknownKeyFor @NonNull @Initialized String resource) {
        try {
            return this.parse(URI.create(resource), this.loader.loadDocument(resource));
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized OpenApiResult parse(@UnknownKeyFor @NonNull @Initialized URI baseUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        try {
            return this.parseVersion(baseUri, document);
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized OpenApiResult parseVersion(@UnknownKeyFor @NonNull @Initialized URI baseUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        String version = this.getVersion(baseUri, document);
        if (this.isVersion30(version)) {
            return this.parse30(baseUri, document);
        }
        if (this.isVersion31(version)) {
            return this.parse31(baseUri, document);
        }
        throw new UnknownVersionException(version);
    }

    private @UnknownKeyFor @NonNull @Initialized OpenApiResult31 parse31(@UnknownKeyFor @NonNull @Initialized URI baseUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        Resolver resolver = new Resolver(this.documents, this.loader);
        ResolverResult result = resolver.resolve(baseUri, document, new Resolver.Settings(SchemaVersion.Draft202012));
        return new OpenApiResult31(new Context(result.getScope(), result.getRegistry()), Bucket.createBucket((Scope)result.getScope(), (Object)document), this.documents);
    }

    private @UnknownKeyFor @NonNull @Initialized OpenApiResult30 parse30(@UnknownKeyFor @NonNull @Initialized URI baseUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        Resolver resolver = new Resolver(this.documents, this.loader);
        ResolverResult result = resolver.resolve(baseUri, document, new Resolver.Settings(SchemaVersion.Draft4));
        return new OpenApiResult30(new Context(result.getScope(), result.getRegistry()), Bucket.createBucket((Scope)result.getScope(), (Object)document), this.documents);
    }

    private @UnknownKeyFor @NonNull @Initialized String getVersion(@UnknownKeyFor @NonNull @Initialized URI baseUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        Scope scope = Scope.createScope((URI)baseUri, (Object)document, (SchemaVersion)SchemaVersion.getLatest());
        Bucket api = (Bucket)Null.nonNull((Object)Bucket.createBucket((Scope)scope, (Object)document));
        return (String)api.convert("openapi", (PropertyConverter)new StringNotNullConverter());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVersion30(@UnknownKeyFor @NonNull @Initialized String version) {
        return this.checkVersion(version, "3.0");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVersion31(@UnknownKeyFor @NonNull @Initialized String version) {
        return this.checkVersion(version, "3.1");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkVersion(@UnknownKeyFor @NonNull @Initialized String version, @UnknownKeyFor @NonNull @Initialized String prefix) {
        return version.startsWith(prefix);
    }
}

