/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser;

import io.openapiparser.Context;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.Keyword;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.schema.RawValue;
import io.openapiprocessor.jsonschema.schema.Reference;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Types;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OpenApiBundler {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized URI> walked = new HashSet<URI>();
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents;
    private final @UnknownKeyFor @NonNull @Initialized Bucket root;
    private final @UnknownKeyFor @NonNull @Initialized URI rootDocumentUri;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> schemas = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> responses = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parameters = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> examples = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> requestBodies = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> headers = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> securitySchemes = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> links = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> callbacks = new LinkedHashMap<String, Object>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> paths = new LinkedHashMap<String, Object>();

    public OpenApiBundler(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized DocumentStore documents, @UnknownKeyFor @NonNull @Initialized Bucket root) {
        this.context = context;
        this.documents = documents.copy();
        this.root = root;
        this.rootDocumentUri = root.getScope().getDocumentUri();
    }

    public @UnknownKeyFor @NonNull @Initialized Object bundle() {
        URI documentUri = this.root.getScope().getDocumentUri();
        Object document = this.documents.get(documentUri);
        Bucket bundled = Bucket.createBucket((Scope)this.root.getScope(), (Object)document, (JsonPointer)this.root.getLocation());
        if (bundled == null) {
            return null;
        }
        this.walkBucket(bundled);
        Map rawValues = bundled.getRawValues();
        this.mergeComponents(rawValues);
        return rawValues;
    }

    private void mergeComponents(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> bundle) {
        LinkedHashMap<String, Object> bundleComponents = Types.asObject((Object)bundle.get("components"));
        if (bundleComponents == null) {
            bundleComponents = new LinkedHashMap<String, Object>();
            this.mergeMaps(bundleComponents);
            if (!bundleComponents.isEmpty()) {
                bundle.put("components", bundleComponents);
            }
        } else {
            this.mergeMaps((Map<String, Object>)bundleComponents);
        }
    }

    private void mergeMaps(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> components) {
        this.mergeMap(components, "schemas", this.schemas);
        this.mergeMap(components, "responses", this.responses);
        this.mergeMap(components, "parameters", this.parameters);
        this.mergeMap(components, "examples", this.examples);
        this.mergeMap(components, "requestBodies", this.requestBodies);
        this.mergeMap(components, "headers", this.headers);
        this.mergeMap(components, "securitySchemes", this.securitySchemes);
        this.mergeMap(components, "links", this.links);
        this.mergeMap(components, "callbacks", this.callbacks);
        this.mergeMap(components, "paths", this.paths);
    }

    private void mergeMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> components, @UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> propertyValues) {
        if (!propertyValues.isEmpty()) {
            Map bundlePaths = Types.asObject((Object)components.get(property));
            if (bundlePaths == null) {
                components.put(property, propertyValues);
            } else {
                bundlePaths.putAll(propertyValues);
            }
        }
    }

    private void walkBucket(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        Scope scope = bucket.getScope();
        JsonPointer location = bucket.getLocation();
        SchemaVersion version = scope.getVersion();
        ArrayList modifications = new ArrayList();
        bucket.forEach((name, value) -> {
            boolean navigable;
            JsonPointer propLocation = location.append(name);
            Keyword keyword = version.getKeyword(name);
            boolean bl = navigable = keyword != null && keyword.isNavigable();
            if (name.equals(Keywords.REF) && Types.isString((Object)value)) {
                Runnable modify = this.walkRef(bucket, propLocation);
                if (modify != null) {
                    modifications.add(modify);
                }
            } else if (navigable && keyword.isSchema() && Types.isObject((Object)value)) {
                this.walkSchema(scope, value, propLocation);
            } else if (navigable && keyword.isSchemaArray() && Types.isArray((Object)value)) {
                this.walkSchemaArray(scope, value, propLocation);
            } else if (navigable && keyword.isSchemaMap()) {
                this.walkSchemaMap(scope, value, propLocation);
            } else if (keyword == null && Types.isObject((Object)value)) {
                this.walkSchema(scope, value, propLocation);
            } else if (keyword == null && Types.isArray((Object)value)) {
                this.walkSchemaArray(scope, value, propLocation);
            }
        });
        modifications.forEach(Runnable::run);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isExternalDocument(@UnknownKeyFor @NonNull @Initialized URI documentUri) {
        return !documentUri.equals(this.rootDocumentUri);
    }

    private @Nullable @UnknownKeyFor @Initialized Runnable walkRef(@UnknownKeyFor @NonNull @Initialized Bucket bucket, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Map bucketValues = bucket.getRawValues();
        Reference reference = this.context.getReference(bucket);
        URI refUri = reference.getAbsoluteRefUri();
        boolean loop = this.walked.contains(refUri);
        URI documentUri = reference.getDocumentUri();
        boolean external = this.isExternalDocument(documentUri);
        Bucket documentBucket = this.getDocumentBucket(documentUri);
        JsonPointer refPointer = reference.getPointer();
        String refName = refPointer.tail();
        RawValue refValue = OpenApiBundler.getRefValue(documentBucket, refPointer);
        Bucket refBucket = OpenApiBundler.getRefBucket(refPointer, refValue);
        Runnable result = null;
        if (this.isSchemaRef(location, refBucket) && external) {
            this.bundleSchema(bucketValues, refName, refValue, loop);
        } else if (this.isResponsesRef(location) && external) {
            this.bundleResponse(bucketValues, refName, refValue);
        } else if (this.isParametersRef(location) && external) {
            this.bundleParameter(bucketValues, refName, refValue);
        } else if (this.isExamplesRef(location) && external) {
            this.bundleExample(bucketValues, refName, refValue);
        } else if (this.isRequestBodiesRef(location) && external) {
            this.bundleRequestBody(bucketValues, refName, refValue);
        } else if (this.isHeadersRef(location) && external) {
            this.bundleHeader(bucketValues, refName, refValue);
        } else if (this.isSecuritySchemesRef(location) && external) {
            result = this.bundleSecurityScheme(bucketValues, refValue);
        } else if (this.isLinksRef(location) && external) {
            this.bundleLink(bucketValues, refName, refValue);
        } else if (this.isCallbacksRef(location) && external) {
            this.bundleCallback(bucketValues, refName, refValue);
        } else if (this.isPathRef(location) && external) {
            result = this.bundlePath30(bucketValues, refValue);
        }
        if (!loop) {
            this.walked.add(refUri);
            this.walkBucket(refBucket);
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized Bucket getRefBucket(@UnknownKeyFor @NonNull @Initialized JsonPointer refPointer, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        Bucket ref = Bucket.createBucket((Scope)refValue.getScope(), (Object)refValue.getValue(), (JsonPointer)refPointer);
        if (ref == null) {
            throw new RuntimeException();
        }
        return ref;
    }

    private void bundleSchema(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue, @UnknownKeyFor @NonNull @Initialized boolean loop) {
        if (!loop) {
            this.schemas.put(refName, refValue.getValue());
        }
        rawValues.put(Keywords.REF, this.createRefPointer("schemas", refName));
    }

    private void bundleResponse(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.responses.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("responses", refName));
    }

    private void bundleParameter(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.parameters.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("parameters", refName));
    }

    private void bundleExample(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.examples.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("examples", refName));
    }

    private void bundleRequestBody(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.requestBodies.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("requestBodies", refName));
    }

    private void bundleHeader(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.headers.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("headers", refName));
    }

    private @UnknownKeyFor @NonNull @Initialized Runnable bundleSecurityScheme(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        Map replacement = Types.asObject((Object)refValue.getValue());
        if (replacement == null) {
            throw new RuntimeException();
        }
        return () -> {
            rawValues.remove(Keywords.REF);
            rawValues.putAll(replacement);
        };
    }

    private void bundleLink(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.links.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("links", refName));
    }

    private void bundleCallback(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized String refName, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        this.callbacks.put(refName, refValue.getValue());
        rawValues.put(Keywords.REF, this.createRefPointer("callbacks", refName));
    }

    private @UnknownKeyFor @NonNull @Initialized Runnable bundlePath30(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawValues, @UnknownKeyFor @NonNull @Initialized RawValue refValue) {
        Map replacement = Types.asObject((Object)refValue.getValue());
        if (replacement == null) {
            throw new RuntimeException();
        }
        return () -> {
            rawValues.remove(Keywords.REF);
            rawValues.putAll(replacement);
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized RawValue getRefValue(@UnknownKeyFor @NonNull @Initialized Bucket documentBucket, @UnknownKeyFor @NonNull @Initialized JsonPointer refPointer) {
        RawValue refValue = documentBucket.getRawValue(refPointer);
        if (refValue == null) {
            throw new RuntimeException();
        }
        return refValue;
    }

    private @UnknownKeyFor @NonNull @Initialized Bucket getDocumentBucket(@UnknownKeyFor @NonNull @Initialized URI documentUri) {
        Object document = this.documents.get(documentUri);
        if (document == null) {
            throw new RuntimeException();
        }
        Scope scope = Scope.createScope((URI)documentUri, (Object)document, (SchemaVersion)SchemaVersion.Draft4);
        return Bucket.createBucket((Scope)scope, (Object)document);
    }

    private @UnknownKeyFor @NonNull @Initialized String createRefPointer(@UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized String refName) {
        return String.format("#/components/%s/%s", type, refName);
    }

    private void walkSchema(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope scope = currentScope.move(value);
        Bucket bucket = Bucket.createBucket((Scope)scope, (Object)value, (JsonPointer)location);
        if (bucket == null) {
            return;
        }
        this.walkBucket(bucket);
    }

    private void walkSchemaArray(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Collection items = Types.asArray((Object)value);
        if (items == null) {
            return;
        }
        int index = 0;
        for (Object item : items) {
            JsonPointer itemLocation = location.append(index);
            this.walkSchema(currentScope, item, itemLocation);
            ++index;
        }
    }

    private void walkSchemaMap(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope targetScope = currentScope.move(value);
        Bucket bucket = Bucket.createBucket((Scope)targetScope, (Object)value, (JsonPointer)location);
        if (bucket == null) {
            return;
        }
        bucket.forEach((propName, propValue) -> {
            JsonPointer propLocation = location.append(propName);
            this.walkSchema(targetScope, propValue, propLocation);
        });
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isSchemaRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        List tokens = location.getTokens();
        boolean schema = tokens.size() > 2 && ((String)tokens.get(tokens.size() - 2)).equals("schema") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
        boolean property = tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("properties") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
        return schema || property;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isResponsesRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("responses") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isParametersRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("parameters") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isExamplesRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("examples") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isRequestBodiesRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 2 && ((String)tokens.get(tokens.size() - 2)).equals("requestBody") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isHeadersRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("headers") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isSecuritySchemesRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("securitySchemes") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isLinksRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("links") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isCallbacksRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() > 3 && ((String)tokens.get(tokens.size() - 3)).equals("callbacks") && ((String)tokens.get(tokens.size() - 1)).equals(Keywords.REF);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPathRef(@UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        List tokens = location.getTokens();
        return tokens.size() == 3 && ((String)tokens.get(0)).equals("paths") && ((String)tokens.get(2)).equals(Keywords.REF);
    }
}

