/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.support;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ValidInt {
    private final @UnknownKeyFor @NonNull @Initialized boolean valid;
    private final @UnknownKeyFor @NonNull @Initialized int value;

    public ValidInt() {
        this.valid = false;
        this.value = 0;
    }

    public ValidInt(@UnknownKeyFor @NonNull @Initialized int value) {
        this.valid = true;
        this.value = value;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isValid() {
        return this.valid;
    }

    public @UnknownKeyFor @NonNull @Initialized int getValue() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isInRange(@UnknownKeyFor @NonNull @Initialized int min, @UnknownKeyFor @NonNull @Initialized int max) {
        if (!this.valid) {
            return false;
        }
        return this.value >= min && this.value <= max;
    }

    public static @UnknownKeyFor @NonNull @Initialized ValidInt parse(@UnknownKeyFor @NonNull @Initialized String source) {
        try {
            return new ValidInt(Integer.parseInt(source));
        }
        catch (Exception ex) {
            return new ValidInt();
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ValidInt parseHex(@UnknownKeyFor @NonNull @Initialized String source) {
        try {
            return new ValidInt(Integer.parseInt(source, 16));
        }
        catch (Exception ex) {
            return new ValidInt();
        }
    }
}

