/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.support;

import io.openapiprocessor.jsonschema.validator.support.IpV4Validator;
import io.openapiprocessor.jsonschema.validator.support.ValidInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IpV6Validator {
    private final @UnknownKeyFor @NonNull @Initialized String ip;

    public IpV6Validator(@UnknownKeyFor @NonNull @Initialized String ipv6) {
        this.ip = ipv6;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validate() {
        if (this.ip.contains("/")) {
            return false;
        }
        List<String> octets = this.expandZeros(this.ip);
        if (octets.isEmpty()) {
            return false;
        }
        int count = 0;
        for (String octet : octets) {
            if (!octet.codePoints().allMatch(c -> c < 128)) {
                return false;
            }
            ValidInt value = ValidInt.parseHex(octet);
            if (value.isValid() && value.isInRange(0, 65535)) {
                ++count;
                continue;
            }
            return false;
        }
        return count == 8;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> expandZeros(@UnknownKeyFor @NonNull @Initialized String ip) {
        int lastZeroShortcut;
        int firstZeroShortcut = ip.indexOf("::");
        if (firstZeroShortcut != (lastZeroShortcut = ip.lastIndexOf("::"))) {
            return Collections.emptyList();
        }
        ArrayList<String> octets = new ArrayList<String>();
        List<String> parts = Arrays.asList(ip.split(":", -1));
        int firstColon = ip.indexOf(":");
        if (firstColon == 0 && firstColon != firstZeroShortcut) {
            return Collections.emptyList();
        }
        int lastColon = ip.lastIndexOf(":");
        if (lastColon == ip.length() && lastColon != lastZeroShortcut + 1) {
            return Collections.emptyList();
        }
        String lastPart = parts.get(parts.size() - 1);
        boolean lastIsIp4 = new IpV4Validator(lastPart).validate();
        if (lastIsIp4) {
            parts = parts.subList(0, parts.size() - 1);
            parts = new ArrayList<String>(parts);
            String[] split = lastPart.split("\\.");
            ValidInt p1 = ValidInt.parse(split[0]);
            ValidInt p2 = ValidInt.parse(split[1]);
            ValidInt p3 = ValidInt.parse(split[2]);
            ValidInt p4 = ValidInt.parse(split[3]);
            int seven = (p1.getValue() << 8) + p2.getValue();
            int eight = (p3.getValue() << 8) + p4.getValue();
            parts.add(Integer.toHexString(seven));
            parts.add(Integer.toHexString(eight));
        }
        long cntZeros = 0L;
        if (firstZeroShortcut >= 0) {
            cntZeros = 8L - parts.stream().filter(p -> !p.isEmpty()).count();
        }
        boolean addedZeros = false;
        for (String part : parts) {
            if (part.isEmpty() && cntZeros > 0L && !addedZeros) {
                int z = 0;
                while ((long)z < cntZeros) {
                    octets.add("0");
                    ++z;
                }
                addedZeros = true;
            }
            if (part.isEmpty()) continue;
            octets.add(part);
        }
        return octets;
    }
}

