/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.support;

import io.openapiprocessor.jsonschema.validator.support.ValidInt;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IpV4Validator {
    private final @UnknownKeyFor @NonNull @Initialized String ip;

    public IpV4Validator(@UnknownKeyFor @NonNull @Initialized String ipv4) {
        this.ip = ipv4;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validate() {
        if (this.ip.contains("/")) {
            return false;
        }
        String[] bytes = this.ip.split("\\.");
        if (bytes.length != 4) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            String value = bytes[i];
            if (!value.codePoints().allMatch(c -> c < 128)) {
                return false;
            }
            if (value.length() > 1 && value.startsWith("0")) {
                return false;
            }
            ValidInt bInt = ValidInt.parse(value);
            if (i == 0 && !bInt.isInRange(1, 255)) {
                return false;
            }
            if (i <= 0 || bInt.isInRange(0, 255)) continue;
            return false;
        }
        return true;
    }
}

