/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.IpV4Step;
import io.openapiprocessor.jsonschema.validator.support.IpV4Validator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IpV4 {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public IpV4(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Format format = Format.of(schema.getFormat());
        if (format == null || !IpV4.supportsFormat(format)) {
            return;
        }
        IpV4Step step = new IpV4Step(schema, instance);
        parentStep.add(step);
        if (!this.shouldValidate(schema)) {
            return;
        }
        String instanceValue = this.getInstanceValue(instance);
        boolean valid = new IpV4Validator(instanceValue).validate();
        if (!valid) {
            step.setInvalid();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        boolean shouldAssert = schema.getContext().getVocabularies().requiresFormatAssertion();
        if (!shouldAssert) {
            shouldAssert = this.settings.assertFormat();
        }
        return shouldAssert;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean supportsFormat(@UnknownKeyFor @NonNull @Initialized Format format) {
        return Format.IPV4.equals((Object)format);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asString());
    }
}

